/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.callback;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.stackmob.sdk.callback.StackMobRawCallback;
import com.stackmob.sdk.exception.StackMobException;
import com.stackmob.sdk.exception.StackMobHTTPResponseException;
import com.stackmob.sdk.net.HttpVerb;
import com.stackmob.sdk.util.Http;
import java.util.List;
import java.util.Map;

public abstract class StackMobCallback
extends StackMobRawCallback {
    @Override
    public void unsent(StackMobException e) {
        this.failure(e);
    }

    @Override
    public void temporaryPasswordResetRequired(StackMobException e) {
        this.failure(e);
    }

    @Override
    public void done(HttpVerb requestVerb, String requestURL, List<Map.Entry<String, String>> requestHeaders, String requestBody, Integer responseStatusCode, List<Map.Entry<String, String>> responseHeaders, byte[] responseBody) {
        if (Http.isSuccess(responseStatusCode)) {
            this.success(new String(responseBody));
        } else {
            StackMobHTTPResponseException e = new StackMobHTTPResponseException(responseStatusCode, responseHeaders, responseBody);
            JsonElement errorDescription = new JsonParser().parse(new String(responseBody)).getAsJsonObject().get("error_description");
            if (errorDescription != null && errorDescription.isJsonPrimitive() && errorDescription.getAsJsonPrimitive().isString() && errorDescription.getAsString().startsWith("Temporary password reset required.")) {
                this.temporaryPasswordResetRequired(e);
            } else {
                this.failure(e);
            }
        }
    }

    public abstract void success(String var1);

    public abstract void failure(StackMobException var1);
}

