/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.stackmob.sdk.api.StackMobDatastore;
import com.stackmob.sdk.api.StackMobOptions;
import com.stackmob.sdk.api.StackMobSession;
import com.stackmob.sdk.callback.StackMobCallback;
import com.stackmob.sdk.callback.StackMobRawCallback;
import com.stackmob.sdk.callback.StackMobRedirectedCallback;
import com.stackmob.sdk.exception.StackMobException;
import com.stackmob.sdk.net.HttpVerbWithPayload;
import com.stackmob.sdk.request.StackMobAccessTokenRequest;
import com.stackmob.sdk.request.StackMobRequest;
import com.stackmob.sdk.request.StackMobUserBasedRequest;
import com.stackmob.sdk.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class StackMob {
    private StackMobSession session;
    private String userSchema;
    private String userIdName;
    private String passwordField;
    private String apiUrlFormat;
    private String pushUrlFormat;
    private ExecutorService executor;
    private final Object urlFormatLock = new Object();
    private static final String versionKey = "sdk.version";
    private static String version = null;
    public static String DEFAULT_API_HOST = "api.stackmob.com";
    public static String DEFAULT_USER_SCHEMA_NAME = "user";
    public static String DEFAULT_USER_ID = "username";
    public static String DEFAULT_PASSWORD_FIELD = "password";
    public static StackMobRedirectedCallback DEFAULT_REDIRECTED_CALLBACK = new StackMobRedirectedCallback(){

        @Override
        public void redirected(String originalUrl, Map<String, String> redirectHeaders, String redirectBody, String newURL) {
        }
    };
    protected StackMobRedirectedCallback userRedirectedCallback;
    protected StackMobRedirectedCallback redirectedCallback = new StackMobRedirectedCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redirected(String originalUrl, Map<String, String> redirectHeaders, String redirectBody, String newURL) {
            try {
                URI uri = new URI(newURL);
                Object object = StackMob.this.urlFormatLock;
                synchronized (object) {
                    String host = uri.getHost();
                    if (host.startsWith("push.") && !StackMob.this.pushUrlFormat.equalsIgnoreCase(host)) {
                        StackMob.this.pushUrlFormat = host;
                        StackMob.this.userRedirectedCallback.redirected(originalUrl, redirectHeaders, redirectBody, newURL);
                    } else if (host.startsWith("api.") && !StackMob.this.apiUrlFormat.equalsIgnoreCase(host)) {
                        StackMob.this.apiUrlFormat = host;
                        StackMob.this.userRedirectedCallback.redirected(originalUrl, redirectHeaders, redirectBody, newURL);
                    }
                }
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
    };
    private static StackMob stackmob;
    private StackMobDatastore datastore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion() {
        if (version == null) {
            version = "";
            Properties props = new Properties();
            InputStream buildProps = null;
            try {
                buildProps = StackMob.class.getClassLoader().getResourceAsStream("build.properties");
                props.load(buildProps);
            }
            catch (IOException e) {
            }
            catch (NullPointerException e) {
            }
            finally {
                try {
                    buildProps.close();
                }
                catch (Exception ignore) {}
            }
            if (props.containsKey(versionKey) && props.get(versionKey) != null && "${version}".equals(version = props.getProperty(versionKey))) {
                version = "dev";
            }
        }
        return version;
    }

    private static ExecutorService createNewExecutor() {
        return Executors.newCachedThreadPool();
    }

    public static synchronized StackMob getStackMob() {
        return stackmob;
    }

    public static void setStackMob(StackMob stackmob) {
        StackMob.stackmob = stackmob;
    }

    public StackMob(Integer apiVersionNumber, String apiKey) {
        this(OAuthVersion.Two, apiVersionNumber, apiKey, null);
    }

    public StackMob(OAuthVersion oauthVersion, Integer apiVersionNumber, String apiKey, String apiSecret) {
        this(oauthVersion, apiVersionNumber, apiKey, apiSecret, DEFAULT_API_HOST, DEFAULT_USER_SCHEMA_NAME, DEFAULT_USER_ID, DEFAULT_PASSWORD_FIELD, DEFAULT_REDIRECTED_CALLBACK);
    }

    public StackMob(OAuthVersion oauthVersion, Integer apiVersionNumber, String apiKey, String apiSecret, String apiHost, String userSchema, String userIdName, String passwordFieldName, StackMobRedirectedCallback redirectedCallback) {
        this.session = new StackMobSession(oauthVersion, apiVersionNumber, apiKey, apiSecret, userSchema, userIdName);
        this.executor = StackMob.createNewExecutor();
        this.apiUrlFormat = apiHost;
        this.userSchema = userSchema;
        this.userIdName = userIdName;
        this.passwordField = passwordFieldName;
        this.userRedirectedCallback = redirectedCallback;
        this.datastore = new StackMobDatastore(this.executor, this.session, apiHost, redirectedCallback);
        if (stackmob == null) {
            StackMob.setStackMob(this);
        }
    }

    public StackMob(StackMob other) {
        this.session = other.session;
        this.userRedirectedCallback = other.redirectedCallback;
        this.apiUrlFormat = other.apiUrlFormat;
        this.pushUrlFormat = other.pushUrlFormat;
        this.executor = other.executor;
    }

    public StackMobDatastore getDatastore() {
        return this.datastore;
    }

    public void login(Map<String, String> params, StackMobRawCallback callback) {
        this.login(params, new StackMobOptions(), callback);
    }

    public void login(Map<String, String> params, StackMobOptions options, StackMobRawCallback callback) {
        StackMobRequest req;
        LinkedList<Map.Entry<String, String>> paramList = new LinkedList<Map.Entry<String, String>>(params.entrySet());
        if (this.getSession().isOAuth2()) {
            req = new StackMobAccessTokenRequest(this.executor, this.session, "accessToken", options.getHeaders(), paramList, callback, this.redirectedCallback);
        } else {
            this.session.setLastUserLoginName(params.get(this.userIdName));
            req = new StackMobUserBasedRequest(this.executor, this.session, "login", paramList, callback, this.redirectedCallback);
        }
        req.setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void refreshLogin(StackMobRawCallback callback) {
        if (!this.getSession().isOAuth2()) {
            callback.unsent(new StackMobException("This method is only available with oauth2"));
        } else if (!this.getSession().oauth2RefreshTokenValid()) {
            callback.unsent(new StackMobException("Refresh token invalid"));
        } else {
            StackMobAccessTokenRequest.newRefreshTokenRequest(this.executor, this.session, this.redirectedCallback, callback).setUrlFormat(this.apiUrlFormat).sendRequest();
        }
    }

    public void logout(StackMobRawCallback callback) {
        new StackMobUserBasedRequest(this.executor, this.session, "logout", StackMobRequest.EmptyParams, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
        this.session.setOAuth2TokensAndExpiration(null, null, null, 0);
    }

    public void twitterLogin(String token, String secret, StackMobRawCallback callback) {
        this.twitterLogin(token, secret, new StackMobOptions(), callback);
    }

    public void twitterLogin(String token, String secret, StackMobOptions options, StackMobRawCallback callback) {
        LinkedList<Map.Entry<String, String>> paramList = new LinkedList<Map.Entry<String, String>>();
        paramList.add(new Pair<String, String>("tw_tk", token));
        paramList.add(new Pair<String, String>("tw_ts", secret));
        StackMobRequest req = this.getSession().isOAuth2() ? new StackMobAccessTokenRequest(this.executor, this.session, "twitterAccessToken", options.getHeaders(), paramList, callback, this.redirectedCallback) : new StackMobUserBasedRequest(this.executor, this.session, "twitterlogin", paramList, callback, this.redirectedCallback);
        ((StackMobRequest)req).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void twitterStatusUpdate(String message, StackMobRawCallback callback) {
        LinkedList<Map.Entry<String, String>> paramList = new LinkedList<Map.Entry<String, String>>();
        paramList.add(new Pair<String, String>("tw_st", message));
        new StackMobUserBasedRequest(this.executor, this.session, "twitterStatusUpdate", paramList, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void registerWithTwitterToken(String token, String secret, String username, StackMobRawCallback callback) {
        LinkedList<Map.Entry<String, String>> paramList = new LinkedList<Map.Entry<String, String>>();
        paramList.add(new Pair<String, String>("tw_tk", token));
        paramList.add(new Pair<String, String>("tw_ts", secret));
        if (username != null) {
            paramList.add(new Pair<String, String>("username", username));
        }
        new StackMobUserBasedRequest(this.executor, this.session, "createUserWithTwitter", paramList, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void linkUserWithTwitterToken(String token, String secret, StackMobRawCallback callback) {
        LinkedList<Map.Entry<String, String>> paramList = new LinkedList<Map.Entry<String, String>>();
        paramList.add(new Pair<String, String>("tw_tk", token));
        paramList.add(new Pair<String, String>("tw_ts", secret));
        new StackMobUserBasedRequest(this.executor, this.session, "linkUserWithTwitter", paramList, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void facebookLogin(String token, StackMobRawCallback callback) {
        this.facebookLogin(token, new StackMobOptions(), callback);
    }

    public void facebookLogin(String token, StackMobOptions options, StackMobRawCallback callback) {
        LinkedList<Map.Entry<String, String>> paramList = new LinkedList<Map.Entry<String, String>>();
        paramList.add(new Pair<String, String>("fb_at", token));
        StackMobRequest req = this.getSession().isOAuth2() ? new StackMobAccessTokenRequest(this.executor, this.session, "facebookAccessToken", options.getHeaders(), paramList, callback, this.redirectedCallback) : new StackMobUserBasedRequest(this.executor, this.session, "facebookLogin", paramList, callback, this.redirectedCallback);
        ((StackMobRequest)req).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void registerWithFacebookToken(String token, String username, StackMobRawCallback callback) {
        LinkedList<Map.Entry<String, String>> paramList = new LinkedList<Map.Entry<String, String>>();
        paramList.add(new Pair<String, String>("fb_at", token));
        paramList.add(new Pair<String, String>("username", username));
        new StackMobUserBasedRequest(this.executor, this.session, "createUserWithFacebook", paramList, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void linkUserWithFacebookToken(String token, StackMobRawCallback callback) {
        LinkedList<Map.Entry<String, String>> paramList = new LinkedList<Map.Entry<String, String>>();
        paramList.add(new Pair<String, String>("fb_at", token));
        new StackMobUserBasedRequest(this.executor, this.session, "linkUserWithFacebook", paramList, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void facebookPostMessage(String msg, StackMobRawCallback callback) {
        LinkedList<Map.Entry<String, String>> paramList = new LinkedList<Map.Entry<String, String>>();
        paramList.add(new Pair<String, String>("message", msg));
        new StackMobUserBasedRequest(this.executor, this.session, "postFacebookMessage", paramList, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void getFacebookUserInfo(StackMobRawCallback callback) {
        new StackMobUserBasedRequest(this.executor, this.session, "getFacebookUserInfo", StackMobRequest.EmptyParams, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void getTwitterUserInfo(StackMobRawCallback callback) {
        new StackMobUserBasedRequest(this.executor, this.session, "getTwitterUserInfo", StackMobRequest.EmptyParams, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void forgotPassword(String username, StackMobRawCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        new StackMobUserBasedRequest(this.executor, this.session, HttpVerbWithPayload.POST, StackMobRequest.EmptyHeaders, StackMobRequest.EmptyParams, params, "forgotPassword", callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void resetPassword(String oldPassword, String newPassword, StackMobRawCallback callback) {
        HashMap params = new HashMap();
        HashMap<String, String> oldPW = new HashMap<String, String>();
        oldPW.put("password", oldPassword);
        HashMap<String, String> newPW = new HashMap<String, String>();
        newPW.put("password", newPassword);
        params.put("old", oldPW);
        params.put("new", newPW);
        new StackMobUserBasedRequest(this.executor, this.session, HttpVerbWithPayload.POST, StackMobRequest.EmptyHeaders, StackMobRequest.EmptyParams, params, "resetPassword", callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void getLoggedInUser(StackMobCallback callback) {
        this.datastore.get(this.userSchema + "/loggedInUser", (StackMobRawCallback)callback);
    }

    public void getLoggedInUser(StackMobOptions options, StackMobCallback callback) {
        this.datastore.get(this.userSchema + "/loggedInUser", options, (StackMobRawCallback)callback);
    }

    public String getLoggedInUsername() {
        return this.isLoggedIn() ? this.session.getLastUserLoginName() : null;
    }

    public boolean isLoggedIn() {
        if (this.getSession().isOAuth2()) {
            return this.getSession().oauth2RefreshTokenValid();
        }
        Map.Entry<String, Date> sessionCookie = this.session.getCookieManager().getSessionCookie();
        if (sessionCookie != null) {
            boolean cookieIsStillValid = sessionCookie.getValue() == null || sessionCookie.getValue().before(new Date());
            return cookieIsStillValid && !this.isLoggedOut();
        }
        return false;
    }

    public boolean refreshRequired() {
        return this.getSession().isOAuth2() && !this.getSession().oauth2TokenValid();
    }

    public boolean isUserLoggedIn(String username) {
        return username != null && username.equals(this.getLoggedInUsername());
    }

    public boolean isLoggedOut() {
        if (this.getSession().isOAuth2()) {
            return this.getSession().getOAuth2TokenExpiration() != null && !this.getSession().oauth2TokenValid();
        }
        Map.Entry<String, Date> sessionCookie = this.session.getCookieManager().getSessionCookie();
        return sessionCookie != null && sessionCookie.getKey().contains(":");
    }

    public StackMobSession getSession() {
        return this.session;
    }

    public void setSession(StackMobSession session) {
        this.session = session;
        this.datastore.setSession(session);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public StackMobRedirectedCallback getRedirectedCallback() {
        return this.userRedirectedCallback;
    }

    public OAuthVersion getOAuthVersion() {
        return this.session.getOAuthVersion();
    }

    public String getUserIdName() {
        return this.userIdName;
    }

    public String getPasswordField() {
        return this.passwordField;
    }

    public static enum OAuthVersion {
        One,
        Two;

    }
}

