/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.stackmob.sdk.util.ListHelpers;
import com.stackmob.sdk.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StackMobOptions {
    private List<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
    private List<String> selection = null;
    private int expandDepth = 0;
    private boolean https = false;
    private static final String SelectHeader = "X-StackMob-Select";
    private static final String ExpandHeader = "X-StackMob-Expand";

    public static StackMobOptions none() {
        return new StackMobOptions();
    }

    public static StackMobOptions https(boolean https) {
        return new StackMobOptions().withHTTPS(https);
    }

    public static StackMobOptions header(String name, String value) {
        return StackMobOptions.none().withHeader(name, value);
    }

    public static StackMobOptions headers(Map<String, String> headerMap) {
        return StackMobOptions.none().withHeaders(headerMap);
    }

    public static StackMobOptions headers(List<Map.Entry<String, String>> headers) {
        StackMobOptions.none();
        return StackMobOptions.headers(headers);
    }

    public static StackMobOptions selectedFields(List<String> fields) {
        return StackMobOptions.none().withSelectedFields(fields);
    }

    public static StackMobOptions depthOf(int depth) {
        return StackMobOptions.none().withDepthOf(depth);
    }

    public StackMobOptions withHTTPS(boolean https) {
        this.https = https;
        return this;
    }

    public StackMobOptions withHeader(String name, String value) {
        this.headers.add(new Pair<String, String>(name, value));
        return this;
    }

    public StackMobOptions withHeaders(Map<String, String> headerMap) {
        for (Map.Entry<String, String> header : headerMap.entrySet()) {
            this.headers.add(header);
        }
        return this;
    }

    public StackMobOptions withHeaders(List<Map.Entry<String, String>> headers) {
        this.headers.addAll(headers);
        return this;
    }

    public StackMobOptions withSelectedFields(List<String> fields) {
        this.selection = fields;
        this.headers.add(new Pair<String, String>(SelectHeader, ListHelpers.join(fields, ",")));
        return this;
    }

    public StackMobOptions withDepthOf(Integer i) {
        if (i > 3) {
            throw new IllegalArgumentException("Maximum expand depth is 3");
        }
        this.headers.add(new Pair<String, String>(ExpandHeader, i.toString()));
        this.expandDepth = i;
        return this;
    }

    public boolean isHTTPS() {
        return this.https;
    }

    List<Map.Entry<String, String>> getHeaders() {
        return this.headers;
    }

    public int getExpandDepth() {
        return this.expandDepth;
    }

    public List<String> getSelection() {
        return this.selection;
    }
}

