/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.request;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.stackmob.sdk.api.StackMob;
import com.stackmob.sdk.api.StackMobSession;
import com.stackmob.sdk.callback.StackMobRawCallback;
import com.stackmob.sdk.callback.StackMobRedirectedCallback;
import com.stackmob.sdk.exception.StackMobException;
import com.stackmob.sdk.net.HttpRedirectHelper;
import com.stackmob.sdk.net.HttpVerb;
import com.stackmob.sdk.net.HttpVerbHelper;
import com.stackmob.sdk.net.HttpVerbWithPayload;
import com.stackmob.sdk.net.HttpVerbWithoutPayload;
import com.stackmob.sdk.net.StackMobApi;
import com.stackmob.sdk.push.StackMobPushToken;
import com.stackmob.sdk.push.StackMobPushTokenDeserializer;
import com.stackmob.sdk.push.StackMobPushTokenSerializer;
import com.stackmob.sdk.request.StackMobAccessTokenRequest;
import com.stackmob.sdk.util.Http;
import com.stackmob.sdk.util.ListHelpers;
import com.stackmob.sdk.util.Pair;
import com.stackmob.sdk.util.StackMobLogger;
import com.stackmob.sdk.util.StackMobNull;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.scribe.builder.ServiceBuilder;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuthService;

public abstract class StackMobRequest {
    public static final List<Map.Entry<String, String>> EmptyHeaders = new ArrayList<Map.Entry<String, String>>();
    public static final List<Map.Entry<String, String>> EmptyParams = new ArrayList<Map.Entry<String, String>>();
    protected static final String SECURE_SCHEME = "https";
    protected static final String REGULAR_SCHEME = "http";
    protected static final String API_KEY_HEADER = "X-StackMob-API-Key";
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected final ExecutorService executor;
    protected final StackMobSession session;
    protected StackMobRawCallback callback;
    protected final StackMobRedirectedCallback redirectedCallback;
    protected HttpVerb httpVerb;
    protected String methodName;
    protected String urlFormat = StackMob.DEFAULT_API_HOST;
    protected Boolean isSecure = false;
    protected List<Map.Entry<String, String>> params = new ArrayList<Map.Entry<String, String>>();
    protected List<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
    private AtomicBoolean triedRefreshToken = new AtomicBoolean(false);
    protected Gson gson;
    private OAuthService oAuthService;

    protected StackMobRequest(ExecutorService executor, StackMobSession session, HttpVerb verb, List<Map.Entry<String, String>> headers, List<Map.Entry<String, String>> params, String method, StackMobRawCallback cb, StackMobRedirectedCallback redirCb) {
        this.executor = executor;
        this.session = session;
        this.httpVerb = verb;
        this.headers = headers;
        this.params = params;
        this.methodName = method;
        this.callback = cb;
        this.redirectedCallback = redirCb;
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(StackMobPushToken.class, (Object)new StackMobPushTokenDeserializer()).registerTypeAdapter(StackMobPushToken.class, (Object)new StackMobPushTokenSerializer()).registerTypeAdapter(StackMobNull.class, (Object)new StackMobNull.Adapter()).excludeFieldsWithModifiers(new int[]{2, 4, 128, 8});
        this.gson = gsonBuilder.create();
        if (!session.isOAuth2()) {
            this.oAuthService = new ServiceBuilder().provider(StackMobApi.class).apiKey(session.getKey()).apiSecret(session.getSecret()).build();
        }
    }

    public StackMobRequest setUrlFormat(String urlFmt) {
        this.urlFormat = urlFmt;
        return this;
    }

    protected abstract String getRequestBody();

    public void sendRequest() {
        try {
            if (HttpVerbWithoutPayload.GET == this.httpVerb) {
                this.sendGetRequest();
            } else if (HttpVerbWithPayload.POST == this.httpVerb) {
                this.sendPostRequest();
            } else if (HttpVerbWithPayload.PUT == this.httpVerb) {
                this.sendPutRequest();
            } else if (HttpVerbWithoutPayload.DELETE == this.httpVerb) {
                this.sendDeleteRequest();
            } else {
                StackMobException ex = new StackMobException(String.format("The StackMob SDK doesn't support the HTTP verb %s at this time", this.httpVerb.toString()));
                this.callback.unsent(ex);
            }
        }
        catch (StackMobException e) {
            this.callback.unsent(e);
        }
    }

    protected void sendGetRequest() throws StackMobException {
        try {
            String query = StackMobRequest.formatQueryString(this.params);
            URI uri = this.createURI(this.getScheme(), this.urlFormat, this.getPath(), query);
            OAuthRequest req = this.getOAuthRequest(HttpVerbWithoutPayload.GET, uri.toString());
            this.sendRequest(req);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (ExecutionException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    protected void sendPostRequest() throws StackMobException {
        try {
            URI uri = this.createURI(this.getScheme(), this.urlFormat, this.getPath(), "");
            String payload = this.getRequestBody();
            OAuthRequest req = this.getOAuthRequest(HttpVerbWithPayload.POST, uri.toString(), payload);
            this.sendRequest(req);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (ExecutionException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    protected void sendPutRequest() throws StackMobException {
        try {
            URI uri = this.createURI(this.getScheme(), this.urlFormat, this.getPath(), "");
            String payload = this.getRequestBody();
            OAuthRequest req = this.getOAuthRequest(HttpVerbWithPayload.PUT, uri.toString(), payload);
            this.sendRequest(req);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (ExecutionException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    protected void sendDeleteRequest() throws StackMobException {
        try {
            String query = StackMobRequest.formatQueryString(this.params);
            URI uri = this.createURI(this.getScheme(), this.urlFormat, this.getPath(), query);
            OAuthRequest req = this.getOAuthRequest(HttpVerbWithoutPayload.DELETE, uri.toString());
            this.sendRequest(req);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (ExecutionException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    protected URI createURI(String scheme, String host, String path, String query) throws URISyntaxException {
        StringBuilder uriBuilder = new StringBuilder().append(scheme).append("://").append(host);
        if (!path.startsWith("/")) {
            uriBuilder.append("/");
        }
        uriBuilder.append(this.escapePath(path));
        if (query != null && query.length() > 0) {
            uriBuilder.append("?").append(query);
        }
        return new URI(uriBuilder.toString());
    }

    private String escapePath(String path) throws URISyntaxException {
        String[] parts = path.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            try {
                if (i == parts.length - 1) {
                    sb.append(URLEncoder.encode(parts[i], "utf-8"));
                } else {
                    sb.append(parts[i]);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new URISyntaxException(parts[i], "could not be URL-encoded as UTF-8");
            }
            if (i == parts.length - 1) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    protected String getPath() {
        if (this.methodName.startsWith("/")) {
            return this.methodName;
        }
        return "/" + this.methodName;
    }

    protected String getScheme() {
        if (this.session.getHTTPSOverride() == null) {
            return this.isSecure != false ? SECURE_SCHEME : REGULAR_SCHEME;
        }
        return this.session.getHTTPSOverride() != false ? SECURE_SCHEME : REGULAR_SCHEME;
    }

    protected static String percentEncode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8").replace("+", "%20");
    }

    protected static String formatQueryString(List<Map.Entry<String, String>> params) {
        LinkedList<String> paramList = new LinkedList<String>();
        for (Map.Entry<String, String> pair : params) {
            String key = pair.getKey();
            String value = pair.getValue();
            try {
                paramList.add(String.format("%s=%s", StackMobRequest.percentEncode(key), StackMobRequest.percentEncode(value)));
            }
            catch (UnsupportedEncodingException e) {}
        }
        return ListHelpers.join(paramList, "&");
    }

    protected String getContentType() {
        return "application/json";
    }

    protected StackMob.OAuthVersion getOAuthVersion() {
        return this.session.getOAuthVersion();
    }

    protected OAuthRequest getOAuthRequest(HttpVerb method, String url) {
        Verb verb = Verb.valueOf((String)method.toString());
        OAuthRequest oReq = new OAuthRequest(verb, url);
        int apiVersion = this.session.getApiVersionNumber();
        String accept = "application/vnd.stackmob+json; version=" + apiVersion;
        ArrayList headerList = new ArrayList();
        if (!verb.equals((Object)Verb.GET) && !verb.equals((Object)Verb.DELETE)) {
            headerList.add(new Pair<String, String>("Content-Type", this.getContentType()));
        }
        headerList.add(new Pair<String, String>("Accept", accept));
        headerList.add(new Pair<String, String>("User-Agent", this.session.getUserAgent()));
        String cookieHeader = this.session.getCookieManager().cookieHeader();
        if (cookieHeader.length() > 0) {
            headerList.add(new Pair<String, String>("Cookie", cookieHeader));
        }
        if (this.headers != null) {
            for (Map.Entry entry : this.headers) {
                headerList.add(new Pair(entry.getKey(), entry.getValue()));
            }
        }
        for (Map.Entry entry : headerList) {
            oReq.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        switch (this.getOAuthVersion()) {
            case One: {
                this.oAuthService.signRequest(new Token("", ""), oReq);
                break;
            }
            case Two: {
                oReq.addHeader(API_KEY_HEADER, this.session.getKey());
                if (!this.session.oauth2TokenValid()) break;
                String urlNoScheme = url.substring(this.getScheme().length() + 3);
                int n = urlNoScheme.indexOf("/");
                String[] hostAndPort = urlNoScheme.substring(0, n).split(":");
                String host = hostAndPort[0];
                String port = this.getPort(hostAndPort);
                String uri = urlNoScheme.substring(n);
                oReq.addHeader(AUTHORIZATION_HEADER, this.session.generateMacToken(method.toString(), uri, host, port));
            }
        }
        return oReq;
    }

    private String getPort(String[] hostAndPort) {
        if (hostAndPort.length > 1) {
            return hostAndPort[1];
        }
        return this.getScheme().equals(SECURE_SCHEME) ? "443" : "80";
    }

    protected OAuthRequest getOAuthRequest(HttpVerb method, String url, String payload) {
        OAuthRequest req = this.getOAuthRequest(method, url);
        req.addPayload(payload);
        return req;
    }

    protected static HttpVerb getRequestVerb(OAuthRequest req) {
        Enum requestVerb = HttpVerbWithoutPayload.GET;
        if (req.getVerb() == Verb.POST) {
            requestVerb = HttpVerbWithPayload.POST;
        } else if (req.getVerb() == Verb.PUT) {
            requestVerb = HttpVerbWithPayload.PUT;
        } else if (req.getVerb() == Verb.DELETE) {
            requestVerb = HttpVerbWithoutPayload.DELETE;
        }
        return requestVerb;
    }

    protected static List<Map.Entry<String, String>> getRequestHeaders(OAuthRequest req) {
        ArrayList<Map.Entry<String, String>> requestHeaders = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry header : req.getHeaders().entrySet()) {
            requestHeaders.add(header);
        }
        return requestHeaders;
    }

    protected boolean tryRefreshToken() {
        return true;
    }

    private boolean canDoRefreshToken() {
        return this.session.isOAuth2() && this.session.oauth2RefreshTokenValid() && this.tryRefreshToken() && !this.triedRefreshToken.get();
    }

    protected void refreshTokenAndResend() {
        this.triedRefreshToken.set(true);
        StackMobAccessTokenRequest.newRefreshTokenRequest(this.executor, this.session, this.redirectedCallback, new StackMobRawCallback(){

            @Override
            public void unsent(StackMobException e) {
                StackMobRequest.this.sendRequest();
            }

            @Override
            public void temporaryPasswordResetRequired(StackMobException e) {
                StackMobRequest.this.sendRequest();
            }

            @Override
            public void done(HttpVerb requestVerb, String requestURL, List<Map.Entry<String, String>> requestHeaders, String requestBody, Integer responseStatusCode, List<Map.Entry<String, String>> responseHeaders, byte[] responseBody) {
                StackMobRequest.this.sendRequest();
            }
        }).setUrlFormat(this.urlFormat).sendRequest();
    }

    protected void sendRequest(final OAuthRequest req) throws InterruptedException, ExecutionException {
        final StackMobRawCallback cb = this.callback;
        if (this.session.isOAuth2() && !this.session.oauth2TokenValid() && this.canDoRefreshToken()) {
            this.refreshTokenAndResend();
        } else {
            this.executor.submit(new Callable<Object>(){

                @Override
                public String call() throws Exception {
                    try {
                        String body;
                        StackMobRequest.this.session.getLogger().logInfo("%s", "Request URL: " + req.getUrl() + "\nRequest Verb: " + StackMobRequest.getRequestVerb(req) + "\nRequest Headers: " + StackMobRequest.getRequestHeaders(req) + "\nRequest Body: " + req.getBodyContents());
                        Response ret = req.send();
                        try {
                            body = ret.getBody();
                        }
                        catch (Exception e) {
                            body = "{}";
                        }
                        String trimmedBody = body.length() < 1000 ? body : body.subSequence(0, 1000) + " (truncated)";
                        StackMobRequest.this.session.getLogger().logInfo("%s", "Response StatusCode: " + ret.getCode() + "\nResponse Headers: " + ret.getHeaders() + "\nResponse: " + trimmedBody);
                        if (!StackMobRequest.this.session.isOAuth2() && ret.getHeaders() != null) {
                            StackMobRequest.this.session.recordServerTimeDiff(ret.getHeader("Date"));
                        }
                        if (HttpRedirectHelper.isRedirected(ret.getCode())) {
                            StackMobRequest.this.session.getLogger().logInfo("Response was redirected", new Object[0]);
                            String newLocation = HttpRedirectHelper.getNewLocation(ret.getHeaders());
                            HttpVerb verb = HttpVerbHelper.valueOf(req.getVerb().toString());
                            OAuthRequest newReq = StackMobRequest.this.getOAuthRequest(verb, newLocation);
                            if (req.getBodyContents() != null && req.getBodyContents().length() > 0) {
                                newReq = StackMobRequest.this.getOAuthRequest(verb, newLocation, req.getBodyContents());
                            }
                            StackMobRequest.this.redirectedCallback.redirected(req.getUrl(), ret.getHeaders(), body, newReq.getUrl());
                            StackMobRequest.this.sendRequest(newReq);
                        } else {
                            ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
                            if (ret.getHeaders() != null) {
                                for (Map.Entry header : ret.getHeaders().entrySet()) {
                                    headers.add(header);
                                }
                            }
                            if (Http.isSuccess(ret.getCode())) {
                                StackMobRequest.this.session.getCookieManager().storeCookies(ret);
                            }
                            boolean retried = false;
                            if (Http.isUnavailable(ret.getCode())) {
                                int afterMilliseconds = -1;
                                for (Map.Entry entry : headers) {
                                    if (!Http.isRetryAfterHeader((String)entry.getKey())) continue;
                                    try {
                                        int candidateMilliseconds = Integer.parseInt((String)entry.getValue()) * 1000;
                                        if (candidateMilliseconds <= 0) continue;
                                        afterMilliseconds = candidateMilliseconds;
                                    }
                                    catch (Throwable ignore) {}
                                }
                                if (afterMilliseconds != -1 && cb.getRetriesRemaining() > 0 && cb.retry(afterMilliseconds)) {
                                    cb.setRetriesRemaining(cb.getRetriesRemaining() - 1);
                                    StackMobRequest.this.sendRequest();
                                    retried = true;
                                }
                            }
                            if (!retried) {
                                if (ret.getCode() == 401 && StackMobRequest.this.canDoRefreshToken()) {
                                    StackMobRequest.this.refreshTokenAndResend();
                                } else {
                                    try {
                                        cb.setDone(StackMobRequest.getRequestVerb(req), req.getUrl(), StackMobRequest.getRequestHeaders(req), req.getBodyContents(), ret.getCode(), headers, body.getBytes());
                                    }
                                    catch (Throwable t) {
                                        StackMobRequest.this.session.getLogger().logError("Callback threw error %s", StackMobLogger.getStackTrace(t));
                                    }
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        StackMobRequest.this.session.getLogger().logWarning("Invoking callback after unexpected exception %s", StackMobLogger.getStackTrace(t));
                        cb.setDone(StackMobRequest.getRequestVerb(req), req.getUrl(), StackMobRequest.getRequestHeaders(req), req.getBodyContents(), -1, EmptyHeaders, t.getMessage().getBytes());
                    }
                    return null;
                }
            });
        }
    }
}

