/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import java.util.ArrayList;
import java.util.List;

public class StackMobGeoPoint {
    private static final double EarthRadiusInMi = 3956.6;
    private static final double EarthRadiusInKm = 6367.5;
    private Double lon = Double.NaN;
    private Double lat = Double.NaN;
    private Double distance = null;

    public StackMobGeoPoint(Double lon, Double lat) {
        if (lon < -180.0 || lon > 180.0 || lat < -90.0 || lat > 90.0) {
            throw new IllegalArgumentException("Invalid latitude/longitude. Longitude must be between -180 and 180, while Latitude must be between -90 and 90");
        }
        this.lon = lon;
        this.lat = lat;
    }

    public Double getLongitude() {
        return this.lon;
    }

    public Double getLatitude() {
        return this.lat;
    }

    public Double getQueryDistanceRadians() {
        return this.distance;
    }

    public List<String> asList() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.getLatitude().toString());
        arguments.add(this.getLongitude().toString());
        return arguments;
    }

    public static Double radiansToMi(double radians) {
        return radians * 3956.6;
    }

    public static Double radiansToKm(double radians) {
        return radians * 6367.5;
    }

    public static Double miToRadians(double mi) {
        return mi / 3956.6;
    }

    public static Double kmToRadians(double km) {
        return km / 6367.5;
    }
}

