/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.model;

import com.stackmob.sdk.api.StackMob;
import com.stackmob.sdk.api.StackMobOptions;
import com.stackmob.sdk.callback.StackMobCallback;
import com.stackmob.sdk.callback.StackMobIntermediaryCallback;
import com.stackmob.sdk.callback.StackMobQueryCallback;
import com.stackmob.sdk.callback.StackMobRawCallback;
import com.stackmob.sdk.exception.StackMobException;
import com.stackmob.sdk.model.StackMobModel;
import com.stackmob.sdk.push.StackMobPush;
import com.stackmob.sdk.push.StackMobPushToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class StackMobUser
extends StackMobModel {
    String password;

    @Override
    public void save(StackMobOptions options, StackMobCallback callback) {
        super.save(this.password == null ? options : options.suggestHTTPS(true), callback);
    }

    public static void sentForgotPasswordEmail(String username, StackMobCallback callback) {
        StackMob.getStackMob().forgotPassword(username, callback);
    }

    public static <T extends StackMobUser> void pushToMultiple(Map<String, String> payload, List<T> users, StackMobRawCallback callback) {
        ArrayList<String> userIds = new ArrayList<String>();
        for (StackMobUser user : users) {
            userIds.add(user.getID());
        }
        StackMobPush.getPush().pushToUsers(payload, userIds, callback);
    }

    public static <T extends StackMobUser> void getLoggedInUser(Class<T> classOfT, StackMobQueryCallback<T> callback) {
        StackMobUser.getLoggedInUser(classOfT, new StackMobOptions(), callback);
    }

    public static <T extends StackMobUser> void getLoggedInUser(final Class<T> classOfT, StackMobOptions options, final StackMobQueryCallback<T> callback) {
        StackMob.getStackMob().getLoggedInUser(options, new StackMobCallback(){

            @Override
            public void success(String responseBody) {
                ArrayList list = new ArrayList();
                try {
                    list.add(StackMobModel.newFromJson(classOfT, responseBody));
                    callback.success(list);
                }
                catch (Exception e) {
                    callback.failure(new StackMobException(e.getMessage()));
                }
            }

            @Override
            public void failure(StackMobException e) {
                callback.failure(e);
            }
        });
    }

    @Deprecated
    public static String getLoggedInUsername() {
        return StackMob.getStackMob().getLoggedInUsername();
    }

    protected StackMobUser(Class<? extends StackMobUser> actualClass, String username, String password) {
        super(actualClass);
        this.setID(username);
        this.password = password;
    }

    protected StackMobUser(Class<? extends StackMobUser> actualClass, String username) {
        this(actualClass, username, null);
    }

    protected StackMobUser(Class<? extends StackMobUser> actualClass) {
        this(actualClass, null);
    }

    @Override
    public String getSchemaName() {
        return StackMob.getStackMob().getSession().getUserObjectName();
    }

    @Override
    public String getIDFieldName() {
        return "username";
    }

    public String getUsername() {
        return this.getID();
    }

    private Map<String, String> getLoginArgs() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put(StackMob.getStackMob().getUserIdName(), this.getID());
        args.put(StackMob.getStackMob().getPasswordField(), this.password);
        return args;
    }

    protected void login(Map<String, String> args, StackMobOptions options, StackMobCallback callback) {
        StackMob.getStackMob().login(args, options, new StackMobIntermediaryCallback(callback){

            @Override
            public void success(String responseBody) {
                StackMobUser.this.password = null;
                StackMobUser.this.fillUserFromJson(responseBody);
                super.success(responseBody);
            }
        });
    }

    private void fillUserFromJson(String responseBody) {
        try {
            this.fillFromJson(responseBody);
        }
        catch (StackMobException e) {
            StackMob.getStackMob().getSession().getLogger().logWarning("Error filling in user model from login" + e, new Object[0]);
        }
    }

    public void login(StackMobCallback callback) {
        this.login(this.getLoginArgs(), new StackMobOptions(), callback);
    }

    public void login(StackMobOptions options, StackMobCallback callback) {
        this.login(this.getLoginArgs(), options, callback);
    }

    public void loginResettingTemporaryPassword(String newPassword, StackMobCallback callback) {
        this.loginResettingTemporaryPassword(newPassword, new StackMobOptions(), callback);
    }

    public void loginResettingTemporaryPassword(String newPassword, StackMobOptions options, StackMobCallback callback) {
        Map<String, String> args = this.getLoginArgs();
        args.put("new_password", newPassword);
        this.login(args, options, callback);
    }

    public void loginWithFacebook(String facebookToken, StackMobCallback callback) {
        this.loginWithFacebook(facebookToken, false, null, new StackMobOptions(), callback);
    }

    public void loginWithFacebook(String facebookToken, boolean createUser, String username, StackMobOptions options, StackMobCallback callback) {
        StackMob.getStackMob().facebookLogin(facebookToken, createUser, username, options, new StackMobIntermediaryCallback(callback){

            @Override
            public void success(String responseBody) {
                StackMobUser.this.fillUserFromJson(responseBody);
                super.success(responseBody);
            }
        });
    }

    public void loginWithTwitter(String twitterToken, String twitterSecret, StackMobCallback callback) {
        this.loginWithTwitter(twitterToken, twitterSecret, false, null, new StackMobOptions(), callback);
    }

    public void loginWithTwitter(String twitterToken, String twitterSecret, boolean createUser, String username, StackMobOptions options, StackMobCallback callback) {
        StackMob.getStackMob().twitterLogin(twitterToken, twitterSecret, createUser, username, options, new StackMobIntermediaryCallback(callback){

            @Override
            public void success(String responseBody) {
                StackMobUser.this.fillUserFromJson(responseBody);
                super.success(responseBody);
            }
        });
    }

    public void loginWithGigya(String gigyaUid, String timestamp, String sig, StackMobOptions options, StackMobCallback callback) {
        StackMob.getStackMob().gigyaLogin(gigyaUid, timestamp, sig, options, new StackMobIntermediaryCallback(callback){

            @Override
            public void success(String responseBody) {
                StackMobUser.this.fillUserFromJson(responseBody);
                super.success(responseBody);
            }
        });
    }

    public void refreshLogin(StackMobCallback callback) {
        StackMob.getStackMob().refreshLogin(callback);
    }

    public void logout(StackMobCallback callback) {
        StackMob.getStackMob().logout(callback);
    }

    public boolean isLoggedIn() {
        return StackMob.getStackMob().isUserLoggedIn(this.getID());
    }

    public boolean refreshRequired() {
        return this.isLoggedIn() && StackMob.getStackMob().refreshRequired();
    }

    public void createWithFacebook(String facebookToken, StackMobCallback callback) {
        StackMob.getStackMob().registerWithFacebookToken(facebookToken, this.getID(), new StackMobIntermediaryCallback(callback){

            @Override
            public void success(String responseBody) {
                StackMobUser.this.fillUserFromJson(responseBody);
                super.success(responseBody);
            }
        });
    }

    public void createWithTwitter(String twitterToken, String twitterSecret, StackMobCallback callback) {
        StackMob.getStackMob().registerWithTwitterToken(twitterToken, twitterSecret, this.getID(), new StackMobIntermediaryCallback(callback){

            @Override
            public void success(String responseBody) {
                StackMobUser.this.fillUserFromJson(responseBody);
                super.success(responseBody);
            }
        });
    }

    public void linkWithFacebook(String facebookToken, StackMobCallback callback) {
        if (this.isLoggedIn()) {
            StackMob.getStackMob().linkUserWithFacebookToken(facebookToken, callback);
        } else {
            callback.unsent(new StackMobException("User not logged in"));
        }
    }

    public void unlinkFromFacebook(StackMobCallback callback) {
        if (this.isLoggedIn()) {
            StackMob.getStackMob().unlinkUserFromFacebook(callback);
        } else {
            callback.unsent(new StackMobException("User not logged in"));
        }
    }

    public void linkWithTwitter(String twitterToken, String twitterSecret, StackMobCallback callback) {
        if (this.isLoggedIn()) {
            StackMob.getStackMob().linkUserWithTwitterToken(twitterToken, twitterSecret, callback);
        } else {
            callback.unsent(new StackMobException("User not logged in"));
        }
    }

    public void unlinkFromTwitter(StackMobCallback callback) {
        if (this.isLoggedIn()) {
            StackMob.getStackMob().unlinkUserFromTwitter(callback);
        } else {
            callback.unsent(new StackMobException("User not logged in"));
        }
    }

    public void postFacebookMessage(String msg, StackMobRawCallback callback) {
        if (this.isLoggedIn()) {
            StackMob.getStackMob().facebookPostMessage(msg, callback);
        } else {
            callback.unsent(new StackMobException("User not logged in"));
        }
    }

    public void postTwitterUpdate(String message, StackMobRawCallback callback) {
        if (this.isLoggedIn()) {
            StackMob.getStackMob().twitterStatusUpdate(message, callback);
        } else {
            callback.unsent(new StackMobException("User not logged in"));
        }
    }

    public void getFacebookUserInfo(StackMobRawCallback callback) {
        if (this.isLoggedIn()) {
            StackMob.getStackMob().getFacebookUserInfo(callback);
        } else {
            callback.unsent(new StackMobException("User not logged in"));
        }
    }

    public void getTwitterUserInfo(StackMobRawCallback callback) {
        if (this.isLoggedIn()) {
            StackMob.getStackMob().getTwitterUserInfo(callback);
        } else {
            callback.unsent(new StackMobException("User not logged in"));
        }
    }

    public void resetPassword(String oldPassword, String newPassword, StackMobCallback callback) {
        if (this.isLoggedIn()) {
            StackMob.getStackMob().resetPassword(oldPassword, newPassword, callback);
        } else {
            callback.unsent(new StackMobException("User not logged in"));
        }
    }

    public void registerForPush(StackMobPushToken token, StackMobRawCallback callback) {
        StackMobPush.getPush().registerForPushWithUser(token, this.getID(), callback);
    }

    public void sendPush(Map<String, String> payload, StackMobRawCallback callback) {
        StackMobPush.getPush().pushToUsers(payload, Arrays.asList(this.getID()), callback);
    }

    public void removeFromPush(StackMobPushToken token, StackMobRawCallback callback) {
        StackMobPush.getPush().removePushToken(token, callback);
    }

    public void getPushTokens(StackMobRawCallback callback) {
        StackMobPush.getPush().getTokensForUsers(Arrays.asList(this.getID()), callback);
    }
}

