/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.util;

public class Http {
    public static final Integer SuccessResponseLowerLimit = 100;
    public static final Integer SuccessResponseUpperLimit = 400;
    public static final Integer UnavailableResponseCode = 503;
    public static final String RetryAfterLowercase = "retry-after";

    public static boolean isSuccess(Integer statusCode) {
        return statusCode < SuccessResponseUpperLimit && statusCode >= SuccessResponseLowerLimit;
    }

    public static boolean isUnavailable(Integer statusCode) {
        return statusCode != null && statusCode.equals(UnavailableResponseCode);
    }

    public static boolean isRetryAfterHeader(String headerName) {
        return headerName != null && headerName.toLowerCase().equals(RetryAfterLowercase);
    }

    public static String fullDomain(String scheme, String domain) {
        return String.format("%s://%s", scheme, domain);
    }
}

