package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.call.StringeeCall;
import com.stringee.call.StringeeCall2;
import com.stringee.common.Utils;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by luannguyen on 1/11/2018.
 */

public class CallInfoFromServer extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                String callId = packet.getFieldString("callId");
                JSONObject callInfo = (JSONObject) packet.getField("info");
                ConcurrentHashMap<String, StringeeCall> callMap = client.getCallMap();
                if (callId != null) {
                    StringeeCall stringeeCall = callMap.get(callId);
                    if (stringeeCall != null) {
                        StringeeCall.StringeeCallListener listener = stringeeCall.getCallListener();
                        if (listener != null) {
                            listener.onCallInfo(stringeeCall, callInfo);
                        }
                    } else {
                        StringeeCall2 stringeeCall2 = client.getCallMap2().get(callId);
                        if (stringeeCall2 != null) {
                            StringeeCall2.StringeeCallListener listener = stringeeCall2.getCallListener();
                            if (listener != null) {
                                listener.onCallInfo(stringeeCall2, callInfo);
                            }
                        }
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(CallInfoFromServer.class, e);
            }
        });
    }
}
