package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.call.CallType;
import com.stringee.call.StringeeCall;
import com.stringee.call.StringeeIceServer;
import com.stringee.common.Common;
import com.stringee.common.SendPacketUtils;
import com.stringee.common.StringeeConstant;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.LinkedList;

/**
 * Created by luannguyen on 8/30/2017.
 */

public class CallStart extends ProcessorBase {

    @Override
    public void process(final StringeeClient client, final Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                String customDataFromYourServer = packet.optFieldString("customDataFromYourServer", "");
                final StringeeCall stringeeCall = client.getCallRequest().get(requestId);
                if (stringeeCall == null) {
                    return;
                }
                CallbackListener listener = Common.callbackListenerMap.get(requestId);
                if (r == 0) {
                    final String callId = packet.optFieldString("callId");
                    if (stringeeCall.getCallStatus() == StringeeConstant.SIP_CODE_ENDED) { // The call is hangup
                        int reqId;
                        synchronized (Common.lock) {
                            reqId = ++Common.requestId;
                        }
                        SendPacketUtils.endCall(client, callId, reqId, "Current call is ended");
                        return;
                    }
                    boolean isP2P = packet.optFieldBoolean("peerToPeerCall", false);
                    String toType = packet.optFieldString("toType");
                    boolean isCallOut = toType.equalsIgnoreCase("external");
                    JSONArray jsonArray = packet.optFieldJSONArray("iceServers");
                    LinkedList<StringeeIceServer> iceServers = new LinkedList<>();
                    if (!Utils.isEmpty(jsonArray)) {
                        for (int i = 0; i < jsonArray.length(); i++) {
                            JSONObject jsonObject = jsonArray.getJSONObject(i);
                            StringeeIceServer iceServer = new StringeeIceServer(jsonObject.getString("urls"), jsonObject.getString("username"), jsonObject.getString("credential"));
                            iceServers.add(iceServer);
                        }
                    }
                    stringeeCall.setP2P(isP2P);
                    stringeeCall.setState(StringeeCall.SignalingState.CALLING);
                    stringeeCall.setCallId(callId);
                    stringeeCall.setCallType(isCallOut ? CallType.APP_TO_PHONE : CallType.APP_TO_APP_OUTGOING);
                    stringeeCall.setCustomDataFromYourServer(customDataFromYourServer);
                    stringeeCall.setIceServers(iceServers);
                    if (listener != null) {
                        listener.onSuccess(stringeeCall);
                    }
                } else {
                    String error = "Can not make a call.";
                    switch (r) {
                        case 1:
                            error = "answer_url is empty.";
                            break;
                        case 2:
                            error = "answer_url SCCO format is incorrect.";
                            break;
                        case 3:
                            error = "To type is not internal or external.";
                            break;
                        case 4:
                            error = "From number not found.";
                            break;
                        case 5:
                            error = "From number is not your account's answer.";
                            break;
                        case 6:
                            error = "Sip trunk not found.";
                            break;
                        case 7:
                            error = "Sip trunk is not linked to your account.";
                            break;
                        case 8:
                            error = "Your balance is not enough to make a call.";
                            break;
                        case 9:
                            error = "Can not connect to charging server.";
                            break;
                        case 10:
                            error = "Pricing table is not configured.";
                            break;
                        case 11:
                            error = "This call is blocked.";
                            break;
                    }
                    if (listener != null) {
                        listener.onError(new StringeeError(r, error));
                    }
                }
                client.getCallRequest().remove(requestId);
            } catch (JSONException e) {
                Utils.reportException(CallStart.class, e);
            }
        });
    }
}
