package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.User;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class
ChatUserEndTypingNotification extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                String convId = packet.getFieldString("convId");
                String userId = packet.getFieldString("userId");
                String userName = packet.optFieldString("displayName");
                User user = new User(userId);
                if (!Utils.isEmpty(userName)) {
                    user.setName(userName);
                }
                client.getConversationFromServer(convId, new CallbackListener<Conversation>() {
                    @Override
                    public void onSuccess(Conversation conv) {
                        if (conv != null) {
                            EventManager.sendUserTypingEvent(client, false, conv, user);
                        }
                    }
                });
            } catch (JSONException e) {
                Utils.reportException(ChatUserEndTypingNotification.class, e);
            }
        });
    }
}