package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.database.DBHandler;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.StringeeChange;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class DeleteConversation extends ProcessorBase {
    @Override
    public void process(final StringeeClient client, final Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");

                StatusListener statusListener = Common.statusListenerMap.get(requestId);
                if (r == 0) {
                    String convId = packet.getFieldString("convId");
                    DBHandler dbHandler = DBHandler.getInstance(client.getContext());
                    Conversation conversation = dbHandler.getConversationByRemoteId(convId, client.getUserId());
                    client.getDbExecutor().execute(() -> {
                        dbHandler.deleteConversationByConvId(convId, client.getUserId());
                        dbHandler.deleteMessagesByConvId(convId, client.getUserId());
                        dbHandler.deleteAllParticipants(convId);
                    });

                    EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.DELETE, conversation));
                    if (statusListener != null) {
                        statusListener.onSuccess();
                    }
                } else {
                    if (statusListener != null) {
                        statusListener.onError(new StringeeError(r, "Failed to delete the conversation"));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(DeleteConversation.class, e);
            }
        });
    }
}
