package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.database.DBHandler;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.Message;
import com.stringee.messaging.Message.Type;
import com.stringee.messaging.StringeeChange;
import com.stringee.messaging.User;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONArray;
import org.json.JSONException;

public class DeleteMessages extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                StatusListener statusListener = Common.statusListenerMap.get(requestId);
                if (r == 0) {
                    DBHandler dbHandler = DBHandler.getInstance(client.getContext());
                    String convId = packet.getFieldString("convId");
                    JSONArray msgArray = packet.optFieldJSONArray("messageIds");
                    if (!Utils.isEmpty(msgArray)) {
                        String[] msgIds = new String[msgArray.length()];
                        for (int i = 0; i < msgArray.length(); i++) {
                            msgIds[i] = msgArray.getString(i);
                            Message message = dbHandler.getMessageByMsgId(convId, msgArray.getString(i), client.getUserId(), false);
                            if (message != null) {
                                EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.DELETE, message));
                            }
                        }

                        long maxTime = dbHandler.getMaxTime(convId, client.getUserId(), msgIds);
                        long convMaxTime = dbHandler.getConvMaxTime(convId, client.getUserId());

                        client.getDbExecutor().execute(() -> dbHandler.deleteMessages(convId, client.getUserId(), msgIds));

                        if (maxTime == convMaxTime) { // Delete latest message, update conversation
                            Message message = dbHandler.getLastMessage(convId, client.getUserId());
                            Conversation conversation = dbHandler.getConversationByRemoteId(convId, client.getUserId());
                            if (conversation != null) {
                                if (message != null) {
                                    conversation.setText(message.getText());
                                    conversation.setLastMessage(message);
                                } else {
                                    conversation.setText("");
                                    Message lastMessage = new Message(Type.NOTIFICATION);
                                    lastMessage.setSender(new User(client.getUserId()));
                                    conversation.setLastMessage(lastMessage);
                                }
                                client.getDbExecutor().execute(() -> dbHandler.updateConversation(conversation));
                                EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.UPDATE, conversation));
                            }
                        }

                    }
                    if (statusListener != null) {
                        statusListener.onSuccess();
                    }
                } else {
                    String message = packet.getFieldString("message");
                    if (statusListener != null) {
                        statusListener.onError(new StringeeError(r, message));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(DeleteMessages.class, e);
            }
        });
    }
}
