package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.database.DBHandler;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.Message;
import com.stringee.messaging.StringeeChange;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;
import org.json.JSONObject;

public class EditMessageFromServer extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                String convId = packet.getFieldString("convId");
                String msgId = packet.getFieldString("msgId");
                String newContent = packet.getFieldString("newContent");
                DBHandler dbHandler = DBHandler.getInstance(client.getContext());
                if (!Utils.isEmpty(newContent)) {
                    JSONObject jsonObject = new JSONObject(newContent);
                    String content = jsonObject.getString("content");
                    Message message = dbHandler.getMessageByMsgId(convId, msgId, client.getUserId(), false);
                    if (message != null) {
                        message.setText(content);
                        client.getDbExecutor().execute(() -> dbHandler.updateMessageByMsgId(message));
                        EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.UPDATE, message));
                        client.getConversationFromServer(convId, new CallbackListener<Conversation>() {
                            @Override
                            public void onSuccess(Conversation conversation) {
                                if (message.getId().equals(conversation.getLastMessage().getId())) {
                                    EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.UPDATE, conversation));
                                }
                            }
                        });
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(EditMessageFromServer.class, e);
            }
        });
    }
}
