package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.listener.StringeeRoomListener;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.video.StringeeRoom;

import org.json.JSONException;

public class LeaveRoom extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                String roomId = packet.optFieldString("roomId");
                StatusListener listener = Common.statusListenerMap.get(requestId);
                if (r == 0) {
                    if (listener != null) {
                        listener.onSuccess();
                    }
                    StringeeRoom room = client.getRoomMap().get(roomId);
                    if (room != null) {
                        room.setState(StringeeRoom.State.DISCONNECTED);
                        StringeeRoomListener roomListener = room.getListener();
                        if (roomListener != null) {
                            roomListener.onDisconnected(room);
                        }
                    }
                    client.getRoomMap().remove(roomId);
                } else {
                    if (listener != null) {
                        listener.onError(new StringeeError(r, packet.optFieldString("message", "Failed to leave the room")));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(LeaveRoom.class, e);
            }
        });
    }
}
