package com.stringee.video;

import android.content.Context;

import com.stringee.common.Common;
import com.stringee.common.Utils;

import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.RendererCommon;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.SurfaceViewRenderer;

/**
 * Created by luannguyen on 10/19/2017.
 */

public class StringeeStream {

    public static class StringeeStreamStats {
        public int packetsLost;
        public int packetsReceived;
        public int bytesReceived;
        public double timeStamp;

        public StringeeStreamStats() {
        }
    }

    public interface StringeeStreamListener {
        void onStreamMediaAvailable(StringeeStream stream);
    }

    public interface StringeeStreamStatsListener {
        void onCallStats(StringeeStreamStats statsReport);
    }

    public enum StreamState {
        UNKNOWN, OPENING, ACTIVE, CLOSING, DESTROYED, LOCAL, BLOCKED,
    }

    private StringeeStreamListener streamListener;

    public StringeeStreamListener getStreamListener() {
        return streamListener;
    }

    public void setStreamListener(StringeeStreamListener streamListener) {
        this.streamListener = streamListener;
    }

    /**
     * identifier for this stream
     */
    private String mId;

    /**
     * has data?
     */
    private boolean mData;
    /**
     * has video?
     */
    private boolean mVideo = true;
    /**
     * has screen stream?
     */
    private boolean mScreen;
    /**
     * has audio?
     */
    private boolean mAudio = true;

    /**
     * the attribute information
     */
    private JSONObject mAttributes = new JSONObject();

    /**
     * flag to store if stream is outgoing (true, local) or incoming (false,
     * remote)
     */
    private boolean mLocal;

    private long timestamp;

    private String mUserId;

    private StringeeRoom mStringeeRoom;

    private MediaStream mediaStream;

    private final Context mContext;

    private MediaConstraints mSdpConstraints;

    private StreamState mState = StreamState.UNKNOWN;

    public PeerConnection pc = null;

    private SurfaceViewRenderer surfaceRenderer;

    private SurfaceViewRenderer videoRenderer;

    private SessionDescription mLocalSdp;

    private JSONObject userInfo;

    private boolean isMute;

    public static final String LOCAL_STREAM_ID = "LOCAL_STREAM_ID";

    private boolean isPublished;
    private boolean isSubscribed;

    private String customId;

    // Getter and Setter
    public String getId() {
        return mId;
    }

    public void setId(String mId) {
        this.mId = mId;
    }

    public boolean isData() {
        return mData;
    }

    public void setData(boolean mData) {
        this.mData = mData;
    }

    public boolean isVideo() {
        return mVideo;
    }

    public void setVideo(boolean mVideo) {
        this.mVideo = mVideo;
    }

    public boolean isScreen() {
        return mScreen;
    }

    public void setScreen(boolean mScreen) {
        this.mScreen = mScreen;
    }

    public boolean isAudio() {
        return mAudio;
    }

    public void setAudio(boolean mAudio) {
        this.mAudio = mAudio;
    }

    public JSONObject getAttributes() {
        return mAttributes;
    }

    public void setAttributes(JSONObject mAttributes) {
        this.mAttributes = mAttributes;
    }

    public boolean isLocal() {
        return mLocal;
    }

    public StringeeRoom getRoom() {
        return mStringeeRoom;
    }

    public void setRoom(StringeeRoom mStringeeRoom) {
        this.mStringeeRoom = mStringeeRoom;
    }

    public void setLocal(boolean mLocal) {
        this.mLocal = mLocal;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getUserId() {
        return mUserId;
    }

    public void setUserId(String mUserId) {
        this.mUserId = mUserId;
    }

    public MediaStream getMediaStream() {
        return mediaStream;
    }

    public void setMediaStream(MediaStream mediaStream) {
        this.mediaStream = mediaStream;
    }

    public SessionDescription getLocalSdp() {
        return mLocalSdp;
    }

    public void setLocalSdp(SessionDescription mLocalSdp) {
        this.mLocalSdp = mLocalSdp;
    }

    public MediaConstraints getSdpConstraints() {
        return mSdpConstraints;
    }

    public JSONObject getUserInfo() {
        return userInfo;
    }

    public void setUserInfo(JSONObject userInfo) {
        this.userInfo = userInfo;
    }

    public SurfaceViewRenderer getVideoRenderer() {
        return videoRenderer;
    }

    public void setVideoRenderer(SurfaceViewRenderer videoRenderer) {
        this.videoRenderer = videoRenderer;
    }

    public boolean isMute() {
        return isMute;
    }

    public boolean isPublished() {
        return isPublished;
    }

    public void setPublished(boolean published) {
        isPublished = published;
    }

    public boolean isSubscribed() {
        return isSubscribed;
    }

    public void setSubscribed(boolean subscribed) {
        isSubscribed = subscribed;
    }

    public String getCustomId() {
        return customId;
    }

    public void setCustomId(String customId) {
        this.customId = customId;
    }

    public void parseJson(JSONObject arg) {
        try {
            mId = arg.getString("id");
        } catch (JSONException e) {
            Utils.reportException(StringeeStream.class, e);
        }
        try {
            mData = arg.getBoolean("data");
        } catch (JSONException e) {
            Utils.reportException(StringeeStream.class, e);
        }
        try {
            mVideo = arg.getBoolean("video");
        } catch (JSONException e) {
            Utils.reportException(StringeeStream.class, e);
        }
        try {
            mAudio = arg.getBoolean("audio");
        } catch (JSONException e) {
            Utils.reportException(StringeeStream.class, e);
        }
        try {
            mScreen = arg.getBoolean("screen");
        } catch (JSONException e) {
            Utils.reportException(StringeeStream.class, e);
        }
        try {
            mAttributes = arg.getJSONObject("attributes");
            JSONObject userObject = mAttributes.getJSONObject("userInfo");
            mUserId = userObject.getString("userId");
            timestamp = mAttributes.optLong("timestamp");
        } catch (JSONException e) {
            Utils.reportException(StringeeStream.class, e);
        }
    }

    public JSONObject toJsonOffer(String state) {
        JSONObject result = new JSONObject();
        try {
            if (state != null) {
                result.put("state", state);
            }
            result.put("data", true);
            result.put("audio", true);
            result.put("video", true);
            if (mAttributes == null) {
                mAttributes = new JSONObject();
            }
            mAttributes.put("name", mUserId);
            mAttributes.put("actualName", mUserId);
            mAttributes.put("type", "public");
            mAttributes.put("timestamp", System.currentTimeMillis());
            mAttributes.put("userInfo", userInfo);
            result.put("attributes", mAttributes);
        } catch (JSONException e) {
            Utils.reportException(StringeeStream.class, e);
        }

        return result;
    }

    public StringeeStream(Context context) {
        synchronized (Common.lock) {
            mId = LOCAL_STREAM_ID + ++Common.requestId;
        }
        mContext = context;
        mLocal = true;
    }

    public StringeeStream(Context context, StringeeStreamConfig streamConfig) {
        synchronized (Common.lock) {
            mId = LOCAL_STREAM_ID + ++Common.requestId;
        }
        mContext = context;
        mLocal = true;
        mAudio = streamConfig.audio;
        mVideo = streamConfig.video;
    }

    /**
     * Get stream surface view
     *
     * @return surface view
     */
    public SurfaceViewRenderer getView() {
        if (surfaceRenderer == null) {
            surfaceRenderer = new SurfaceViewRenderer(mContext);
            surfaceRenderer.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FIT);
        }
        return surfaceRenderer;
    }

    public SurfaceViewRenderer getSurfaceRenderer() {
        return surfaceRenderer;
    }

    /**
     * Render stream view
     */
    public void renderView(boolean isOverlay) {
        if (mStringeeRoom != null) {
//            StringeeRoomConnector connector = mStringeeRoom.getConnector();
//            if (connector != null) {
//                connector.renderStream(this, getView(), isOverlay);
//            }
        }
    }

    /**
     * Mute/unmute stream
     *
     * @param mute boolean
     */
    public void mute(boolean mute) {
        isMute = mute;
        if (mStringeeRoom != null) {
//            StringeeRoomConnector connector = mStringeeRoom.getConnector();
//            if (connector != null) {
//                connector.mute(mute);
//            }
        }
    }

    /**
     * Enable/disable video
     *
     * @param enabled boolean
     */
    public void enableVideo(boolean enabled) {
        if (mStringeeRoom != null) {
//            StringeeRoomConnector connector = mStringeeRoom.getConnector();
//            if (connector != null) {
//                connector.enableVideo(enabled);
//            }
        }
    }

    /**
     * Switch camera
     */
    public void switchCamera() {
        if (mStringeeRoom != null) {
//            StringeeRoomConnector connector = mStringeeRoom.getConnector();
//            if (connector != null) {
//                connector.switchCamera(null);
//            }
        }
    }

    public void initLocal(PeerConnection pc, SdpObserver sdpObserver) {
        mLocal = true;
        mState = StreamState.LOCAL;
        this.pc = pc;
        mSdpConstraints = new MediaConstraints();
        mSdpConstraints.mandatory.add(new MediaConstraints.KeyValuePair(
                "OfferToReceiveAudio", "true"));
        mSdpConstraints.mandatory.add(new MediaConstraints.KeyValuePair(
                "OfferToReceiveVideo", "true"));
        pc.createOffer(sdpObserver, mSdpConstraints);
    }

    public void initRemote(final PeerConnection pc, final SdpObserver sdpObserver) {
        mLocal = false;
        mState = StreamState.OPENING;
        this.pc = pc;
        mSdpConstraints = new MediaConstraints();
        mSdpConstraints.mandatory.add(new MediaConstraints.KeyValuePair(
                "OfferToReceiveAudio", "true"));
        mSdpConstraints.mandatory.add(new MediaConstraints.KeyValuePair(
                "OfferToReceiveVideo", "true"));
        pc.createOffer(sdpObserver, mSdpConstraints);
    }

    public void onClosing() {
        mState = StreamState.CLOSING;
    }

    public void onDestroyed() {
        mState = StreamState.DESTROYED;
        mediaStream = null;
    }

    public void onDisable() {
        mState = StreamState.BLOCKED;
        mediaStream = null;
    }

    /**
     * Get stream stats
     *
     * @param listener callback listener
     */
    public void getStats(StringeeStreamStatsListener listener) {
        if (mStringeeRoom != null) {
//            StringeeRoomConnector connector = mStringeeRoom.getConnector();
//            if (connector != null) {
//                connector.getStats(this, listener);
//            }
        }
    }
}
