package com.stringee.video;

import android.util.Log;

import com.stringee.call.StringeeIceCandidate;
import com.stringee.call.StringeeSessionDescription;
import com.stringee.common.Common;
import com.stringee.common.SendPacketUtils;

import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;

import java.util.concurrent.LinkedBlockingQueue;

public class VideoSdpObserver implements SdpObserver {
    private final StringeeVideoTrack videoTrack;
    private final boolean isLocal;
    private StringeeSessionDescription localDescription;

    public VideoSdpObserver(StringeeVideoTrack videoTrack, boolean isLocal) {
        this.videoTrack = videoTrack;
        this.isLocal = isLocal;
    }

    @Override
    public void onCreateSuccess(SessionDescription sessionDescription) {
        videoTrack.getClient().getExecutor().execute(() -> {
            if (isLocal) {
                Log.d("Stringee", "Create offer successfully");
                StringeeSessionDescription.Type type = StringeeSessionDescription.Type.OFFER;
                if (sessionDescription.type == SessionDescription.Type.PRANSWER) {
                    type = StringeeSessionDescription.Type.PRANSWER;
                } else if (sessionDescription.type == SessionDescription.Type.ANSWER) {
                    type = StringeeSessionDescription.Type.ANSWER;
                }
                localDescription = new StringeeSessionDescription(type, sessionDescription.description);
                videoTrack.setLocalDescription(sessionDescription, VideoSdpObserver.this);
            }
        });
    }

    @Override
    public void onSetSuccess() {
        videoTrack.getClient().getExecutor().execute(() -> {
            if (isLocal) {
                videoTrack.setLocalSDPSet(true);
                int requestId;
                synchronized (Common.lock) {
                    requestId = ++Common.requestId;
                }
                SendPacketUtils.sendVideoSDP(videoTrack.getClient(), requestId, videoTrack, localDescription);
            } else {
                videoTrack.setRemoteSDPSet(true);
                LinkedBlockingQueue<StringeeIceCandidate> candidatesQuere = videoTrack.getCandidatesQueue();
                if (candidatesQuere != null) {
                    while (!candidatesQuere.isEmpty()) {
                        StringeeIceCandidate iceCandidate = candidatesQuere.poll();
                        if (iceCandidate != null) {
                            videoTrack.setIceCandidate(iceCandidate);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void onCreateFailure(String s) {

    }

    @Override
    public void onSetFailure(String s) {

    }
}
