package com.stringee.call;

import android.util.Log;

import com.stringee.StringeeClient;
import com.stringee.common.Utils;

import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;

/**
 * Created by luannguyen on 9/27/16.
 */
public class StringeeCreateSdpObserver implements SdpObserver {

    private final boolean createOffer;
    private final StringeeCall stringeeCall;
    private final int holdType; // 1: hold 2: unhold

    public StringeeCreateSdpObserver(boolean createOffer, StringeeCall stringeeCall) {
        this(createOffer, stringeeCall, 0);
    }

    public StringeeCreateSdpObserver(boolean createOffer, StringeeCall stringeeCall, int holdType) {
        this.createOffer = createOffer;
        this.stringeeCall = stringeeCall;
        this.holdType = holdType;
    }

    @Override
    public void onCreateSuccess(final SessionDescription sessionDescription) {
        StringeeClient client = stringeeCall.getClient();
        client.getExecutor().execute(() -> {
            StringeeCallFactory callFactory = stringeeCall.getCallFactory();
            SessionDescription finalDescription = sessionDescription;
            if (callFactory != null) {
                if (holdType == 1) {
                    String description = sessionDescription.description;
                    description = description.replace("a=sendrecv", "a=sendonly");
                    finalDescription = new SessionDescription(sessionDescription.type, description);
                } else if (holdType == 2) {
                    String description = sessionDescription.description;
                    description = description.replace("a=sendonly", "a=sendrecv");
                    description = description.replace("a=inactive", "a=sendrecv");
                    finalDescription = new SessionDescription(sessionDescription.type, description);
                }

                if (stringeeCall.getAudioBandwidth() > 0 || stringeeCall.getVideoBandwidth() > 0) {
                    finalDescription = new SessionDescription(sessionDescription.type, Utils.limitBandwidth(sessionDescription.description, stringeeCall.getAudioBandwidth(), stringeeCall.getVideoBandwidth()));
                }

                callFactory.setLocalDescription(finalDescription);
                StringeeSetSdpObserver setSdpObserver = new StringeeSetSdpObserver(true, createOffer, stringeeCall);
                callFactory.setLocalDescription(setSdpObserver, finalDescription);
            }
        });
    }

    @Override
    public void onCreateFailure(String s) {
        if (createOffer) {
            Log.d("Stringee", "+++++++++++++++++++++++ SDP on Create Offer Failure: " + s);
        } else {
            Log.d("Stringee", "+++++++++++++++++++++++ SDP on Create Answer Failure: " + s);
        }
    }

    @Override
    public void onSetSuccess() {
        Log.d("Stringee", "Set local SDP success");
    }

    @Override
    public void onSetFailure(String s) {
        Log.d("Stringee", "+++++++++++++++++++++++ Set local SDP failed ");
    }
}
