package com.stringee.database;

public class ChatRequestConstant {

    public static final String TABLE_NAME = "chatRequest";
    public static final String ID = "id";
    public static final String CONVERSATION_ID = "conversation_id";
    public static final String STATE = "state";
    public static final String NAME = "name";
    public static final String CREATED_AT = "created_at";
    public static final String UPDATED_AT = "updated_at";
    public static final String USER_ID = "user_id";
    public static final String CUSTOMER_ID = "customer_Id";
    public static final String CHANNEL_TYPE = "channel_type";
    public static final String REQUEST_TYPE = "request_type";
    public static final String TRANSFER_FROM = "transfer_from";
    public static final String TRANSFER_FROM_NAME = "transfer_from_name";
    public static final String TRANSFER_FROM_AVATAR = "transfer_from_avatar";

    public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS " +
            TABLE_NAME + "(" +
            ID + " INTEGER PRIMARY KEY," +
            CONVERSATION_ID + " TEXT," +
            STATE + " INTEGER," +
            NAME + " TEXT," +
            CREATED_AT + " INTEGER," +
            UPDATED_AT + " INTEGER," +
            USER_ID + " TEXT," +
            CUSTOMER_ID + " TEXT," +
            CHANNEL_TYPE + " INTEGER," +
            REQUEST_TYPE + " INTEGER," +
            TRANSFER_FROM + " TEXT," +
            TRANSFER_FROM_NAME + " TEXT," +
            TRANSFER_FROM_AVATAR + " TEXT, UNIQUE(" +
            CONVERSATION_ID + "," + USER_ID + "))";

    public static final String CREATE_CHAT_REQUEST_INDEX = "CREATE INDEX request_index ON " + TABLE_NAME + "("
            + CONVERSATION_ID + ")";
}
