package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.call.CallType;
import com.stringee.call.StringeeCall;
import com.stringee.call.StringeeCallData;
import com.stringee.call.StringeeCallFactory;
import com.stringee.common.StringeeConstant;
import com.stringee.common.Utils;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

/**
 * Created by luannguyen on 8/30/2017.
 */

public class CallStateChange extends ProcessorBase {
    @Override
    public void process(final StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                final String callId = packet.optFieldString("callId");
                final int code = packet.getFieldInt("code");
                final String deviceId = packet.optFieldString("deviceId", "");
                StringeeCall.SignalingState callState = StringeeCall.SignalingState.CALLING;
                String reason = "";
                int sipCode;
                String sipReason = "";
                switch (code) {
                    case StringeeConstant.SIP_CODE_CONNECTING:
                        sipReason = "Trying";
                        reason = "Calling";
                        break;
                    case StringeeConstant.SIP_CODE_SESSION_IN_PROGRESS:
                        callState = StringeeCall.SignalingState.RINGING;
                        sipReason = "Session Progress";
                        reason = "Ringing";
                        break;
                    case StringeeConstant.SIP_CODE_RINGING:
                        callState = StringeeCall.SignalingState.RINGING;
                        sipReason = "Ringing";
                        reason = "Ringing";
                        break;
                    case StringeeConstant.SIP_CODE_OK:
                        callState = StringeeCall.SignalingState.ANSWERED;
                        sipReason = "OK";
                        reason = "Starting";
                        break;
                    case StringeeConstant.SIP_CODE_BUSY:
                    case StringeeConstant.SIP_CODE_BUSY_2:
                        callState = StringeeCall.SignalingState.BUSY;
                        sipReason = "Busy Here";
                        reason = "Busy Here";
                        break;
                    default:
                        if (code >= 400) {
                            callState = StringeeCall.SignalingState.ENDED;
                            sipReason = "";
                            reason = "Ended";
                        }
                        break;
                }

                ConcurrentHashMap<String, StringeeCall> callMap = client.getCallMap();
                final StringeeCall stringeeCall = callMap.get(callId);
                if (stringeeCall != null) {
                    if (stringeeCall.getCallType() == CallType.APP_TO_PHONE) {
                        sipCode = code;
                    } else {
                        sipCode = -1;
                    }
                    stringeeCall.setCallStatus(code);
                    if (code == StringeeConstant.SIP_CODE_OK) {
                        stringeeCall.setDeviceId(deviceId);
                        final StringeeCallFactory callFactory = stringeeCall.getCallFactory();
                        if (callFactory.iceConnected) {
                            stringeeCall.setCallStatus(StringeeConstant.ICE_CONNECTED);
                        }
                        if (stringeeCall.isCaller()) {
                            String id = callId + deviceId;
                            // Set remote sdp
                            StringeeCallData sdpData = client.getSdpMap().get(id);
                            if (sdpData != null) {
                                try {
                                    JSONObject dataObject = new JSONObject(sdpData.getData());
                                    callFactory.processSdp(stringeeCall, dataObject);
                                    client.getSdpMap().remove(id);
                                } catch (JSONException e) {
                                    Utils.reportException(CallStateChange.class, e);
                                }
                            }

                            // Add candidates
                            if (stringeeCall.isRemoteSdpSet()) {
                                LinkedBlockingQueue<StringeeCallData> candidates = client.getCandidatesMap().get(id);
                                if (candidates != null) {
                                    while (!candidates.isEmpty()) {
                                        StringeeCallData callData = candidates.poll();
                                        try {
                                            if (callData != null) {
                                                JSONObject dataObject = new JSONObject(callData.getData());
                                                callFactory.processCandidate(dataObject);
                                            }
                                        } catch (JSONException e) {
                                            Utils.reportException(CallStateChange.class, e);
                                        }
                                    }
                                }
                            }

                            if (!stringeeCall.isP2P()) {
                                stringeeCall.checkToRestartICE();
                            }

                            stringeeCall.startStatsTimer();
                        }
                    }

                    stringeeCall.setState(callState);
                    StringeeCall.StringeeCallListener callListener = stringeeCall.getCallListener();
                    if (callListener != null) {
                        if (stringeeCall.getCallType() != CallType.APP_TO_PHONE) {
                            sipReason = "";
                        }
                        callListener.onSignalingStateChange(stringeeCall, callState, reason, sipCode, sipReason);
                    }

                    if (code >= 400) {
                        stringeeCall.release(true);
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(CallStateChange.class, e);
            }
        });
    }
}
