package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.messaging.ChatRequest;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class ChatAgentResponse extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                int requestId = packet.getFieldInt("requestId");
                int r = packet.getFieldInt("r");
                boolean answer = packet.getBoolean("answer");
                CallbackListener callbackListener = Common.callbackListenerMap.get(requestId);
                StatusListener statusListener = Common.statusListenerMap.get(requestId);
                if (r == 0) {
                    String convId = packet.optFieldString("convId");
                    if (answer) {
                        if (callbackListener != null) {
                            client.getConversationFromServer(convId, new CallbackListener<Conversation>() {
                                @Override
                                public void onSuccess(Conversation conversation) {
                                    callbackListener.onSuccess(conversation);
                                }
                            });
                        } else {
                            ChatRequest chatRequest = client.getChatRequestMap().get(convId);
                            if (chatRequest != null) {
                                EventManager.sendChatSupportHandledEvent(client, chatRequest, ChatRequest.State.ACCEPTED);
                            }
                        }
                    } else {
                        if (statusListener != null) {
                            statusListener.onSuccess();
                        } else {
                            ChatRequest chatRequest = client.getChatRequestMap().get(convId);
                            if (chatRequest != null) {
                                EventManager.sendChatSupportHandledEvent(client, chatRequest, ChatRequest.State.REJECTED);
                            }
                        }
                    }
                } else {
                    if (callbackListener != null) {
                        callbackListener.onError(new StringeeError(r, packet.optFieldString("message", "")));
                    }
                    if (statusListener != null) {
                        statusListener.onError(new StringeeError(r, packet.optFieldString("message", "")));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(ChatAgentResponse.class, e);
            }
        });
    }
}
