package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.database.DBHandler;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.StringeeChange;
import com.stringee.messaging.StringeeChange.Type;
import com.stringee.messaging.User;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

public class ChatRemoveParticipantFromServer extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                DBHandler dbHandler = DBHandler.getInstance(client.getContext());

                String convId = packet.getFieldString("groupId");
                String removedBy = packet.getFieldString("removedBy");
                String removedInfo = packet.getFieldString("removedInfo");
                if (removedInfo != null) {
                    JSONObject removedObj = new JSONObject(removedInfo);
                    String removedId = removedObj.optString("user");

                    Conversation conversation = dbHandler.getConversationByRemoteId(convId, client.getUserId());
                    if (conversation != null) {
                        List<User> participants = conversation.getParticipants();
                        for (int i = 0; i < participants.size(); i++) {
                            if (removedId.equals(participants.get(i).getUserId())) {
                                participants.remove(i);
                                client.getDbExecutor().execute(() -> {
                                    String[] userIds = new String[]{removedId};
                                    dbHandler.deleteParticipants(convId, userIds);
                                });
                                break;
                            }
                        }
                        StringeeChange change;
                        if (removedId.equals(client.getUserId())) {
                            client.getDbExecutor().execute(() -> {
                                dbHandler.deleteConversationByConvId(convId, client.getUserId());
                                dbHandler.deleteMessagesByConvId(convId, client.getUserId());
                                dbHandler.deleteAllParticipants(convId);
                            });
                            change = new StringeeChange(Type.DELETE, conversation);
                        } else {
                            conversation.setParticipants(participants);
                            client.getDbExecutor().execute(() -> dbHandler.updateConversation(conversation));
                            change = new StringeeChange(Type.UPDATE, conversation);
                        }
                        EventManager.sendChatChangeEvent(client, change);
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(ChatRemoveParticipantFromServer.class, e);
            }
        });
    }
}
