package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Utils;
import com.stringee.common.event.Event;
import com.stringee.common.event.EventConstants;
import com.stringee.common.event.EventManager;
import com.stringee.common.event.EventNotify;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.messaging.listeners.LiveChatEventListener;
import com.stringee.network.tcpclient.packet.Packet;

import java.util.List;

public class ChatRequestTimeoutToQueue extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            String convId = packet.optFieldString("convId");
            client.getConversationFromServer(convId, new CallbackListener<Conversation>() {
                @Override
                public void onSuccess(Conversation conversation) {
                    if (conversation != null) {
                        List<LiveChatEventListener> liveChatListeners = client.getLiveChatListeners();
                        if (!Utils.isEmpty(liveChatListeners)) {
                            for (int i = 0; i < liveChatListeners.size(); i++) {
                                LiveChatEventListener listener = liveChatListeners.get(i);
                                client.getListenerExecutor().execute(() -> listener.onTimeoutInQueue(conversation));
                            }
                        }
                        Event event = new Event(EventNotify.CHAT_SUPPORT_TIMEOUT_IN_QUEUE.getValue());
                        event.put(EventConstants.STRINGEE_CLIENT, client);
                        event.put(EventConstants.CONVERSATION, conversation);
                        EventManager.sendChatSupportTimeoutInQueueEvent(client, conversation);
                    }
                }
            });
        });
    }
}
