package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.call.StringeeCall2;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;
import org.json.JSONObject;

public class CustomMessageFromServer extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                String from = packet.getFieldString("fromUser");
                JSONObject message = (JSONObject) packet.getField("message");
                if (message != null) {
                    String type = message.optString("type");
                    if (!Utils.isEmpty(type) && type.equals("capture-request")) {
                        String callId = message.optString("call_id");
                        String requestId = message.optString("requestId");
                        if (!Utils.isEmpty(callId)) {
                            StringeeCall2 stringeeCall2 = client.getCallMap2().get(callId);
                            if (stringeeCall2 != null) {
                                if (stringeeCall2.isVideoEnable()) {
                                    stringeeCall2.snapshotLocal(from, requestId);
                                }
                            }
                        }
                    } else {
                        EventManager.sendClientCustomMsgEvent(client, from, message);
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(CustomMessageFromServer.class, e);
            }
        });
    }
}
