package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.database.DBHandler;
import com.stringee.exception.StringeeError;
import com.stringee.messaging.ChannelType;
import com.stringee.messaging.ChatStatus;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.Conversation.State;
import com.stringee.messaging.Message;
import com.stringee.messaging.User;
import com.stringee.messaging.User.Role;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class GetConversation extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                CallbackListener<Conversation> listener = Common.callbackListenerMap.get(requestId);
                DBHandler dbHandler = DBHandler.getInstance(client.getContext());
                if (r == 0) {
                    JSONArray jsonArray = packet.optFieldJSONArray("listConvs");
                    if (!Utils.isEmpty(jsonArray)) {
                        JSONObject jsonObject = jsonArray.getJSONObject(0);
                        String convId = jsonObject.optString("convId");
                        String localId = jsonObject.optString("localDbId");
                        int unread = jsonObject.optInt("unread");
                        long lastUpdate = jsonObject.optLong("lastUpdate");
                        long created = jsonObject.optLong("created");
                        String creator = jsonObject.optString("creator");
                        boolean isGroup = jsonObject.optBoolean("isGroup");
                        boolean isDistinct;
                        if (!isGroup) {
                            isDistinct = true;
                        } else {
                            isDistinct = jsonObject.optBoolean("isDistinct", true);
                        }
                        String lastMsgSender = jsonObject.optString("lastMsgSender");
                        String lastMsgSenderName = "";
                        String lastMsgSenderAvatar = "";
                        JSONObject lastSenderInfo = jsonObject.optJSONObject("lastMsgSenderInfo");
                        if (lastSenderInfo != null) {
                            if (Utils.isEmpty(lastMsgSender)) {
                                lastMsgSender = lastSenderInfo.optString("user");
                            }
                            lastMsgSenderName = lastSenderInfo.optString("display_name");
                            lastMsgSenderAvatar = lastSenderInfo.optString("avatar_url");
                        }
                        String convName = jsonObject.optString("convName");
                        JSONArray participants = jsonObject.optJSONArray("participants");
                        long convLastSeq = jsonObject.optLong("convLastSeq");
                        long lastMsgSeqReceived = jsonObject.optLong("lastMsgSeqReceived");
                        String pinnedMsgId = jsonObject.optString("pinMsgId", "");
                        ChannelType channelType = ChannelType.getType(jsonObject.optInt("channelType"));
                        boolean ended = jsonObject.optBoolean("ended");
                        State state = State.LEFT;
                        String oaId = jsonObject.optString("oaId");
                        String customData = jsonObject.optString("customData");
                        long lastTimeNewMsg = jsonObject.optLong("lastTimeNewMsg");
                        Message.Type lastMsgType = Message.Type.getType(jsonObject.optInt("lastMsgType"));
                        String lastMsgId = jsonObject.optString("lastMsgId");
                        Message.State lastMsgState = Message.State.SENT;
                        String text = "";
                        Message lastMsg = null;
                        JSONObject lastMsgObj = jsonObject.optJSONObject("lastMsg");
                        ChatStatus chatStatus = ChatStatus.getStatus(jsonObject.optInt("chatStatus"));

                        Conversation conversation = new Conversation();
                        conversation.setId(convId);
                        conversation.setLocalId(localId);
                        conversation.setTotalUnread(unread);
                        conversation.setUpdateAt(lastUpdate);
                        conversation.setGroup(isGroup);
                        conversation.setDistinct(isDistinct);
                        conversation.setName(convName);
                        conversation.setLastSequence(convLastSeq);
                        conversation.setLastMsgSeqReceived(lastMsgSeqReceived);
                        conversation.setPinnedMsgId(pinnedMsgId);
                        conversation.setChannelType(channelType);
                        conversation.setEnded(ended);
                        conversation.setOaId(oaId);
                        conversation.setCustomData(customData);
                        conversation.setCreator(creator);
                        conversation.setCreateAt(created);
                        conversation.setChatStatus(chatStatus);
                        conversation.setClientId(client.getUserId());

                        // Participants
                        List<User> members = new ArrayList<>();
                        long lastConvReceivedSeq = 0;
                        long lastConvSeenSeq = 0;
                        long myLastConvSeenSeq = 0;

                        if (!Utils.isEmpty(participants)) {
                            for (int j = 0; j < participants.length(); j++) {
                                JSONObject parObject = participants.getJSONObject(j);
                                String userId = parObject.optString("user");
                                String name = parObject.optString("displayName", "");
                                String avatar = parObject.optString("avatarUrl", "");
                                String role = parObject.optString("role");
                                long lastMsgReceivedSeq = parObject.optLong("lastMsgSeqReceived");
                                long lastMsgSeqSeen = parObject.optLong("lastMsgSeqSeen");

                                User user = new User(userId);
                                user.setName(name);
                                user.setAvatarUrl(avatar);
                                user.setRole(Role.getRole(role));
                                user.setLastMsgSeqReceived(lastMsgReceivedSeq);
                                user.setLastMsgSeqSeen(lastMsgSeqSeen);
                                members.add(user);

                                if (userId.equals(lastMsgSender)) {
                                    if (Utils.isEmpty(lastMsgSenderName)) {
                                        lastMsgSenderName = name;
                                    }
                                    if (Utils.isEmpty(lastMsgSenderAvatar)) {
                                        lastMsgSenderAvatar = avatar;
                                    }
                                }

                                if (userId.equals(client.getUserId())) {
                                    state = State.DEFAULT;
                                    conversation.setLastMsgSeqSeen(lastMsgSeqSeen);
                                    conversation.setLastMsgSeqReceived(lastMsgSeqReceived);
                                }

                                if (!userId.equals(client.getUserId())) {
                                    if (lastMsgReceivedSeq > lastConvReceivedSeq) {
                                        lastConvReceivedSeq = lastMsgReceivedSeq;
                                    }
                                    if (lastMsgSeqSeen > lastConvSeenSeq) {
                                        lastConvSeenSeq = lastMsgSeqSeen;
                                    }
                                } else {
                                    if (lastMsgSeqSeen > myLastConvSeenSeq) {
                                        myLastConvSeenSeq = lastMsgSeqSeen;
                                    }
                                }
                            }
                        }

                        if (!lastMsgSender.equals(client.getUserId())) {
                            lastMsgState = Message.State.DELIVERED;
                            if (convLastSeq <= myLastConvSeenSeq) {
                                lastMsgState = Message.State.READ;
                            }
                        } else {
                            if (convLastSeq <= lastConvReceivedSeq) {
                                lastMsgState = Message.State.DELIVERED;
                            }
                            if (convLastSeq <= lastConvSeenSeq) {
                                lastMsgState = Message.State.READ;
                            }
                        }
                        conversation.setParticipants(members);
                        conversation.setState(state);

                        // Last Sender
                        User lastSender = new User(lastMsgSender);
                        lastSender.setName(lastMsgSenderName);
                        lastSender.setAvatarUrl(lastMsgSenderAvatar);

                        // Last Message
                        if (lastMsgObj != null) {
                            text = lastMsgObj.optString("content", "");
                            if (Utils.isEmpty(text)) {
                                text = lastMsgObj.optString("text");
                            }
                            double latitude = 0;
                            double longitude = 0;
                            String fileUrl = "";
                            String fileName = "";
                            long fileLength = 0;
                            String fileId = "";
                            String thumbnailUrl = "";
                            int duration = 0;
                            float ratio = 0;
                            String stickerName = "";
                            String stickerCategory = "";
                            String contact = "";
                            switch (lastMsgType) {
                                case RENAME_CONVERSATION:
                                case CREATE_CONVERSATION:
                                case RATING:
                                case NOTIFICATION:
                                    text = lastMsgObj.toString();
                                    break;
                                case LOCATION:
                                    JSONObject locationObject = lastMsgObj.optJSONObject("location");
                                    if (locationObject != null) {
                                        latitude = locationObject.optDouble("lat");
                                        longitude = locationObject.optDouble("lon");
                                    }
                                    break;
                                case CONTACT:
                                    JSONObject contactObject = lastMsgObj.optJSONObject("contact");
                                    if (contactObject != null) {
                                        contact = contactObject.optString("vcard");
                                    }
                                    break;
                                case PHOTO:
                                    JSONObject photoObject = lastMsgObj.optJSONObject("photo");
                                    if (photoObject != null) {
                                        ratio = (float) photoObject.optDouble("ratio", 0);
                                        fileUrl = photoObject.optString("filePath");
                                        thumbnailUrl = photoObject.optString("thumbnail");
                                        fileId = photoObject.optString("file_id");
                                    }
                                    break;
                                case VIDEO:
                                    JSONObject videoObject = lastMsgObj.optJSONObject("video");
                                    if (videoObject != null) {
                                        ratio = (float) videoObject.optDouble("ratio", 0);
                                        fileUrl = videoObject.optString("filePath");
                                        duration = videoObject.optInt("duration");
                                        thumbnailUrl = videoObject.optString("thumbnail");
                                        fileId = videoObject.optString("file_id");
                                        fileName = videoObject.optString("filename");
                                    }
                                    break;
                                case AUDIO:
                                    JSONObject audioObject = lastMsgObj.optJSONObject("audio");
                                    if (audioObject != null) {
                                        fileUrl = audioObject.optString("filePath");
                                        duration = audioObject.optInt("duration");
                                        fileId = audioObject.optString("file_id");
                                        fileName = audioObject.optString("filename");
                                    }
                                    break;
                                case FILE:
                                    JSONObject fileObject = lastMsgObj.optJSONObject("file");
                                    if (fileObject != null) {
                                        fileUrl = fileObject.optString("filePath");
                                        fileName = fileObject.optString("filename");
                                        fileLength = fileObject.optLong("length");
                                        fileId = fileObject.optString("file_id");
                                    }
                                    break;
                                case STICKER:
                                    JSONObject stickerObject = lastMsgObj.optJSONObject("sticker");
                                    if (stickerObject != null) {
                                        stickerCategory = stickerObject.optString("category");
                                        stickerName = stickerObject.optString("name");
                                    }
                                    break;
                            }

                            lastMsg = new Message();
                            lastMsg.setConversationId(convId);
                            lastMsg.setConvLocalId(localId);
                            lastMsg.setId(lastMsgId);
                            lastMsg.setCreatedAt(lastTimeNewMsg);
                            lastMsg.setSender(lastSender);
                            lastMsg.setSequence(convLastSeq);
                            lastMsg.setText(text);
                            lastMsg.setType(lastMsgType);
                            lastMsg.setLatitude(latitude);
                            lastMsg.setLongitude(longitude);
                            lastMsg.setFileUrl(fileUrl);
                            lastMsg.setThumbnailUrl(thumbnailUrl);
                            lastMsg.setDuration(duration);
                            lastMsg.setImageRatio(ratio);
                            lastMsg.setContact(contact);
                            lastMsg.setFileName(fileName);
                            lastMsg.setFileLength(fileLength);
                            lastMsg.setFileId(fileId);
                            lastMsg.setClientId(client.getUserId());
                            lastMsg.setStickerCategory(stickerCategory);
                            lastMsg.setStickerName(stickerName);
                            lastMsg.setState(lastMsgState);
                            if (!lastMsgSender.equals(client.getUserId())) {
                                lastMsg.setMsgType(Message.MsgType.RECEIVE);
                            } else {
                                lastMsg.setMsgType(Message.MsgType.SEND);
                            }
                            JSONObject customObject = lastMsgObj.optJSONObject("metadata");
                            if (customObject != null) {
                                lastMsg.setCustomData(customObject);
                            }
                        }
                        conversation.setLastTimeNewMsg(lastTimeNewMsg);
                        conversation.setText(text);
                        conversation.setLastMsg(lastMsgObj != null ? lastMsgObj.toString() : "");
                        conversation.setLastMessage(lastMsg);

                        client.getDbExecutor().execute(() -> dbHandler.syncConversationToLocalDb(client.getUserId(), conversation));

                        if (listener != null) {
                            listener.onSuccess(conversation);
                        }
                    } else {
                        if (listener != null) {
                            listener.onError(new StringeeError(-3, "No conversation found."));
                        }
                    }
                } else {
                    if (listener != null) {
                        listener.onError(new StringeeError(r, "Fail to get the conversation info."));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(GetConversation.class, e);
            }
        });
    }
}
