package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.call.StringeeCall;
import com.stringee.call.StringeeCall2;
import com.stringee.common.StringeeConstant;
import com.stringee.common.Utils;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by luannguyen on 1/22/2018.
 */

public class MsgFromOtherDevice extends ProcessorBase {
    @Override
    public void process(final StringeeClient client, final Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                String type = packet.optFieldString("type");
                int code;
                if (type.equals("CALL_STATE") || type.equals("CALL_END")) {
                    JSONObject dataObject = packet.optFieldJSONObject("data");
                    String callId = dataObject.optString("callId");
                    StringeeCall stringeeCall = client.getCallMap().get(callId);
                    if (stringeeCall != null) {
                        StringeeCall.StringeeCallListener stateListener = stringeeCall.getCallListener();
                        StringeeCall.SignalingState signalingState;
                        String desc;
                        if (type.equals("CALL_END")) {
                            signalingState = StringeeCall.SignalingState.ENDED;
                            desc = "This call is ended from another device.";
                            stringeeCall.setAnsweredOnAnotherDevice(true);
                            stringeeCall.setState(signalingState);
                            stringeeCall.setCallStatus(StringeeConstant.SIP_CODE_ENDED);
                            if (stateListener != null) {
                                stateListener.onHandledOnAnotherDevice(stringeeCall, signalingState, desc);
                            }
                            stringeeCall.release(true);
                        } else {
                            code = dataObject.getInt("code");
                            stringeeCall.setCallStatus(code);
                            if (code == StringeeConstant.SIP_CODE_BUSY) {
                                signalingState = StringeeCall.SignalingState.BUSY;
                                desc = "This call is rejected from another device.";
                                stringeeCall.setAnsweredOnAnotherDevice(true);
                                stringeeCall.setState(signalingState);
                                if (stateListener != null) {
                                    stateListener.onHandledOnAnotherDevice(stringeeCall, signalingState, desc);
                                }
                                stringeeCall.release(true);
                            } else if (code == StringeeConstant.SIP_CODE_OK) {
                                signalingState = StringeeCall.SignalingState.ANSWERED;
                                desc = "This call is answered from another device.";
                                stringeeCall.setAnsweredOnAnotherDevice(true);
                                stringeeCall.setState(signalingState);
                                if (stateListener != null) {
                                    stateListener.onHandledOnAnotherDevice(stringeeCall, signalingState, desc);
                                }
                                stringeeCall.release(false);
                            } else if (code == StringeeConstant.SIP_CODE_SESSION_IN_PROGRESS) {
                                signalingState = StringeeCall.SignalingState.RINGING;
                                desc = "This call is ringing from another device.";
                                stringeeCall.setState(signalingState);
                                if (stateListener != null) {
                                    stateListener.onHandledOnAnotherDevice(stringeeCall, signalingState, desc);
                                }
                            } else if (code == StringeeConstant.SIP_CODE_RINGING) {
                                signalingState = StringeeCall.SignalingState.RINGING;
                                desc = "This call is ringing from another device.";
                                stringeeCall.setState(signalingState);
                                if (stateListener != null) {
                                    stateListener.onHandledOnAnotherDevice(stringeeCall, signalingState, desc);
                                }
                            }
                        }
                    }
                } else if (type.equals("CALL2_STATE") || type.equals("CALL2_END")) {
                    JSONObject dataObject = packet.optFieldJSONObject("data");
                    String callId = dataObject.getString("callId");
                    StringeeCall2 stringeeCall2 = client.getCallMap2().get(callId);
                    if (stringeeCall2 != null) {
                        StringeeCall2.StringeeCallListener stateListener = stringeeCall2.getCallListener();
                        StringeeCall2.SignalingState signalingState;
                        String desc;
                        if (type.equals("CALL2_END")) {
                            signalingState = StringeeCall2.SignalingState.ENDED;
                            desc = "This call is ended from another device.";
                            stringeeCall2.setAnsweredOnAnotherDevice(true);
                            stringeeCall2.setState(signalingState);
                            stringeeCall2.setCallStatus(StringeeConstant.SIP_CODE_ENDED);
                            if (stateListener != null) {
                                stateListener.onHandledOnAnotherDevice(stringeeCall2, signalingState, desc);
                            }
                            stringeeCall2.release();
                        } else {
                            code = dataObject.getInt("code");
                            stringeeCall2.setCallStatus(code);
                            if (code == StringeeConstant.SIP_CODE_BUSY) {
                                signalingState = StringeeCall2.SignalingState.BUSY;
                                desc = "This call is rejected from another device.";
                                stringeeCall2.setAnsweredOnAnotherDevice(true);
                                stringeeCall2.setState(signalingState);
                                if (stateListener != null) {
                                    stateListener.onHandledOnAnotherDevice(stringeeCall2, signalingState, desc);
                                }
                                stringeeCall2.release();
                            } else if (code == StringeeConstant.SIP_CODE_OK) {
                                signalingState = StringeeCall2.SignalingState.ANSWERED;
                                desc = "This call is answered from another device.";
                                stringeeCall2.setAnsweredOnAnotherDevice(true);
                                stringeeCall2.setState(signalingState);
                                if (stateListener != null) {
                                    stateListener.onHandledOnAnotherDevice(stringeeCall2, signalingState, desc);
                                }
                                stringeeCall2.release();
                            } else if (code == StringeeConstant.SIP_CODE_SESSION_IN_PROGRESS) {
                                signalingState = StringeeCall2.SignalingState.RINGING;
                                desc = "This call is ringing from another device.";
                                stringeeCall2.setState(signalingState);
                                if (stateListener != null) {
                                    stateListener.onHandledOnAnotherDevice(stringeeCall2, signalingState, desc);
                                }
                            } else if (code == StringeeConstant.SIP_CODE_RINGING) {
                                signalingState = StringeeCall2.SignalingState.RINGING;
                                desc = "This call is ringing from another device.";
                                stringeeCall2.setState(signalingState);
                                if (stateListener != null) {
                                    stateListener.onHandledOnAnotherDevice(stringeeCall2, signalingState, desc);
                                }
                            }
                        }
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(MsgFromOtherDevice.class, e);
            }
        });
    }
}
