package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.listener.StringeeRoomListener;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.video.RemoteParticipant;
import com.stringee.video.StringeeRoom;

import org.json.JSONObject;

public class ParticipantLeftRoom extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            String roomId = packet.optFieldString("roomId");
            String reason = packet.optFieldString("reason");
            StringeeRoom stringeeRoom = client.getRoomMap().get(roomId);
            if (stringeeRoom != null) {
                StringeeRoomListener listener = stringeeRoom.getListener();
                JSONObject jsonObject = packet.optFieldJSONObject("user");
                String userId = jsonObject.optString("userId");
                RemoteParticipant remoteParticipant = stringeeRoom.getParticipantMap().get(userId);
                if (remoteParticipant != null) {
                    if (listener != null) {
                        listener.onParticipantDisconnected(stringeeRoom, remoteParticipant);
                    }
                }

                if (reason.equals("ROOM_DELETED") && listener != null) {
                    listener.onDisconnected(stringeeRoom);
                }
            }
        });
    }
}
