package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class SendCustomMessage extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                StatusListener listener = Common.statusListenerMap.get(requestId);
                if (listener != null) {
                    if (r == 0) {
                        listener.onSuccess();
                    } else {
                        listener.onError(new StringeeError(r, "Failed to send a custom message."));
                    }
                }
                Common.statusListenerMap.remove(requestId);
            } catch (JSONException e) {
                Utils.reportException(SendCustomMessage.class, e);
            }
        });
    }
}
