package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class UpdateUserInfo extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                StatusListener listener = Common.statusListenerMap.get(requestId);
                if (listener != null) {
                    if (r == 0) {
                        listener.onSuccess();
                    } else {
                        listener.onError(new StringeeError(r, "Failed to update user info."));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(UpdateUserInfo.class, e);
            }
        });
    }
}
