package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.GetUserInfo;
import com.stringee.common.Utils;
import com.stringee.database.DBHandler;
import com.stringee.exception.StringeeError;
import com.stringee.messaging.User;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.TcpClient;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;
import java.util.Queue;

public class UserInfo extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                CallbackListener<List<User>> listener = Common.callbackListenerMap.get(requestId);
                if (r == 0) {
                    JSONArray jsonArray = (JSONArray) packet.getField("users");
                    if (!Utils.isEmpty(jsonArray)) {
                        List<User> userList = new java.util.ArrayList<>();
                        for (int i = 0; i < jsonArray.length(); i++) {
                            JSONObject jsonObject = jsonArray.getJSONObject(i);
                            String userId = jsonObject.getString("userId");
                            String name = jsonObject.optString("displayName");
                            String avatar = jsonObject.optString("avatarUrl");
                            String email = jsonObject.optString("email");
                            String phone = jsonObject.optString("phone");
                            String location = jsonObject.optString("location");
                            String browser = jsonObject.optString("browser");
                            String platform = jsonObject.optString("platform");
                            String device = jsonObject.optString("device");
                            String ipAddress = jsonObject.optString("ipaddress");
                            String hostName = jsonObject.optString("hostname");
                            String userAgent = jsonObject.optString("useragent");
                            User user = new User(userId);
                            user.setName(name);
                            user.setAvatarUrl(avatar);
                            user.setEmail(email);
                            user.setPhone(phone);
                            user.setLocation(location);
                            user.setBrowser(browser);
                            user.setPlatform(platform);
                            user.setDevice(device);
                            user.setIpAddress(ipAddress);
                            user.setHostName(hostName);
                            user.setUserAgent(userAgent);
                            userList.add(user);

                            Queue<Packet> queue = GetUserInfo.get(userId);
                            if (queue != null) {
                                while (!queue.isEmpty()) {
                                    Packet p1 = queue.remove();
                                    TcpClient tcpClient = client.getTcpClient();
                                    tcpClient.getHandler().havePacket(p1, tcpClient);
                                }
                                // remove queue
                                GetUserInfo.remove(userId);
                            }
                        }
                        client.getDbExecutor().execute(() -> {
                            if (!Utils.isEmpty(userList)) {
                                for (int i = 0; i < userList.size(); i++) {
                                    User user = userList.get(i);
                                    DBHandler.getInstance(client.getContext()).syncUser(user);
                                }
                            }
                        });
                        if (listener != null) {
                            listener.onSuccess(userList);
                        }
                    } else {
                        if (listener != null) {
                            listener.onError(new StringeeError(-3, "No user found"));
                        }
                    }
                } else {
                    if (listener != null) {
                        listener.onError(new StringeeError(r, "SERVER ERROR"));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(UserInfo.class, e);
            }
        });
    }
}
