package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.call.StringeeIceCandidate;
import com.stringee.common.Utils;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.video.StringeeRoom;
import com.stringee.video.StringeeVideoTrack;

import org.json.JSONException;
import org.json.JSONObject;

public class VideoCandidateFromServer extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                String localTrackId = packet.optFieldString("localTrackId");
                String candidate = packet.optFieldString("data");
                JSONObject jsonObject = new JSONObject(candidate);
                String roomId = packet.optFieldString("roomId");
                StringeeRoom room = client.getRoomMap().get(roomId);
                if (room == null) {
                    return;
                }
                StringeeVideoTrack videoTrack = room.getVideoTrackMap().get(localTrackId);
                if (videoTrack != null) {
                    videoTrack.addIceCandidate(new StringeeIceCandidate(jsonObject.getString("sdpMid"), jsonObject.getInt("sdpMLineIndex"), jsonObject.getString("candidate")));
                }
            } catch (JSONException e) {
                Utils.reportException(VideoCandidateFromServer.class, e);
            }
        });
    }
}
