package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Utils;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.video.StringeeRoom;
import com.stringee.video.StringeeVideoTrack;
import com.stringee.video.VideoSdpObserver;

import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.SessionDescription;

public class VideoSDPFromServer extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                String localTrackId = packet.optFieldString("localTrackId");
                String roomId = packet.optFieldString("roomId");
                String connectionId = packet.getFieldString("serverPeerConnectionId");
                JSONObject sdpObject = (JSONObject) packet.getField("data");
                String type = sdpObject.getString("type");
                String sdp = sdpObject.getString("sdp");
                SessionDescription description = new SessionDescription(SessionDescription.Type.ANSWER, sdp);
                StringeeRoom room = client.getRoomMap().get(roomId);
                if (room == null) {
                    return;
                }
                StringeeVideoTrack videoTrack = room.getVideoTrackMap().get(localTrackId);
                if (videoTrack != null) {
                    videoTrack.setRemoteDescription(description, new VideoSdpObserver(videoTrack, false));
                }
            } catch (JSONException e) {
                Utils.reportException(VideoSDPFromServer.class, e);
            }
        });
    }
}
