package com.stringee.network.tcpclient;

import com.stringee.network.tcpclient.packet.Packet;

import java.nio.ByteBuffer;

/**
 * @author Alex
 */

public abstract class HandlerBase {

    public void havePacket(Packet packet, TcpClient tcpClient) {
        onMessageReceived(packet, tcpClient);
    }

    protected void onRead(TcpClient tcpClient, ByteBuffer buf) {
        while (buf.remaining() > 0) {
            if (buf.remaining() < 8) {
                return;
            }
            buf.mark();

            byte[] bytes = new byte[2];
            buf.get(bytes);

            int length = buf.getInt();
            short service = buf.getShort();

            Packet packet = new Packet(service);

            if (length > 0) {
                if (buf.remaining() < length) {
                    buf.reset();
                    return;
                }
                byte[] data = new byte[length];
                buf.get(data);

                packet.setData(data);
            }

            onMessageReceived(packet, tcpClient);
        }
    }

    protected abstract void onMessageReceived(Packet packet, TcpClient tcpClient);

    protected abstract void onConnected(TcpClient tcpClient);

    protected abstract void onDisconnected(TcpClient tcpClient);

    protected abstract void onWriteCompleted(Packet packet, TcpClient tcpClient);

    protected abstract void onUnacceptedCertificate();
}
