package com.stringee.network.tcpclient;

import android.content.Context;

import androidx.annotation.RawRes;

import com.stringee.common.Utils;

import java.io.InputStream;

public class StringeeCertificate {
    private InputStream certificate;

    public StringeeCertificate(Context context, @RawRes int certificateId) {
        try {
            this.certificate = context.getResources().openRawResource(certificateId);
        } catch (RuntimeException e) {
            Utils.reportException(StringeeCertificate.class, e);
        }
    }

    public InputStream getCertificate() {
        return certificate;
    }
}
