package com.stringee.call;

import android.util.Log;

import com.stringee.StringeeClient;
import com.stringee.common.StringeeConstant;
import com.stringee.common.Utils;

import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.MediaConstraints;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;

import java.util.concurrent.LinkedBlockingQueue;

/**
 * Created by luannguyen on 9/27/16.
 */
public class StringeeSetSdpObserver implements SdpObserver {

    private final boolean setOfferSdp;
    private final boolean setLocalSdp;
    private final StringeeCall stringeeCall;

    public StringeeSetSdpObserver(boolean setLocalSdp, boolean setOfferSdp, StringeeCall stringeeCall) {
        this.setLocalSdp = setLocalSdp;
        this.setOfferSdp = setOfferSdp;
        this.stringeeCall = stringeeCall;
    }

    @Override
    public void onSetSuccess() {
        final StringeeClient client = stringeeCall.getClient();
        client.getExecutor().execute(() -> {
            final StringeeCallFactory callFactory = stringeeCall.getCallFactory();
            if (callFactory == null) {
                return;
            }
            if (setLocalSdp) {
                Log.d("Stringee", "...................................... SDP on Set local Success");
                SessionDescription sessionDescription = callFactory.getLocalDescription();
                if (callFactory.getListener() != null) {
                    StringeeSessionDescription.Type type = StringeeSessionDescription.Type.OFFER;
                    if (sessionDescription.type == SessionDescription.Type.PRANSWER) {
                        type = StringeeSessionDescription.Type.PRANSWER;
                    } else if (sessionDescription.type == SessionDescription.Type.ANSWER) {
                        type = StringeeSessionDescription.Type.ANSWER;
                    }
                    StringeeSessionDescription sdp = new StringeeSessionDescription(type, sessionDescription.description);
                    callFactory.getListener().onSetSdpSuccess(sdp);
                }

                stringeeCall.setLocalSdpSet(true);
                if (stringeeCall.isRemoteSdpSet() && (stringeeCall.getCallStatus() == StringeeConstant.SIP_CODE_OK || stringeeCall.getCallStatus() == StringeeConstant.ICE_CONNECTED)) {
                    String id = stringeeCall.getCallId() + stringeeCall.getDeviceId();
                    LinkedBlockingQueue<StringeeCallData> candidatesQuere = client.getCandidatesMap().get(id);
                    if (candidatesQuere != null) {
                        while (!candidatesQuere.isEmpty()) {
                            StringeeCallData callData = candidatesQuere.poll();
                            try {
                                if (callData != null) {
                                    JSONObject dataObject = new JSONObject(callData.getData());
                                    callFactory.processCandidate(dataObject);
                                }
                            } catch (JSONException e) {
                                Utils.reportException(StringeeSetSdpObserver.class, e);
                            }
                        }
                    }
                }
            } else {
                Log.d("Stringee", "...................................... SDP on Set remote Success");
                stringeeCall.setRemoteSdpSet(true);
                // Add remaining candidate when make call
                if (stringeeCall.isLocalSdpSet() && (stringeeCall.getCallStatus() == StringeeConstant.SIP_CODE_OK || stringeeCall.getCallStatus() == StringeeConstant.ICE_CONNECTED)) {
                    String id = stringeeCall.getCallId() + stringeeCall.getDeviceId();
                    LinkedBlockingQueue<StringeeCallData> candidatesQuere = client.getCandidatesMap().get(id);
                    if (candidatesQuere != null) {
                        while (!candidatesQuere.isEmpty()) {
                            StringeeCallData callData = candidatesQuere.poll();
                            try {
                                if (callData != null) {
                                    JSONObject dataObject = new JSONObject(callData.getData());
                                    callFactory.processCandidate(dataObject);
                                }
                            } catch (JSONException e) {
                                Utils.reportException(StringeeSetSdpObserver.class, e);
                            }
                        }
                    }
                }
            }

            if (!setLocalSdp && setOfferSdp) {
                Log.d("Stringee", "...................................... create answer");
                MediaConstraints sdpMediaConstraints = new MediaConstraints();
                sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
                if (stringeeCall.isVideoCall()) {
                    sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "true"));
                } else {
                    sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "false"));
                }
                StringeeCreateSdpObserver createSdpObserver = new StringeeCreateSdpObserver(false, stringeeCall);
                callFactory.createAnswer(createSdpObserver, sdpMediaConstraints);
            }
        });
    }

    @Override
    public void onSetFailure(String s) {
        if (setLocalSdp) {
            Log.d("Stringee", "+++++++++++++++++++++++ SDP on Set local Failure: " + s);
        } else {
            Log.d("Stringee", "+++++++++++++++++++++++ SDP on Set remote Failure: " + s);
        }
    }

    @Override
    public void onCreateSuccess(SessionDescription sessionDescription) {
    }

    @Override
    public void onCreateFailure(String s) {
    }
}
