package com.stringee.common;

import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

@SuppressWarnings("deprecation")
public class MyMultiPartEntity extends MultipartEntity {

    private final ProgressListener listener;

    public MyMultiPartEntity(final ProgressListener listener) {
        super();
        this.listener = listener;
    }

    public MyMultiPartEntity(final HttpMultipartMode mode, final ProgressListener listener) {
        super(mode);
        this.listener = listener;
    }

    public MyMultiPartEntity(HttpMultipartMode mode, final String boundary, final Charset charset, final ProgressListener listener) {
        super(mode, boundary, charset);
        this.listener = listener;
    }

    @Override
    public void writeTo(final OutputStream outStream) throws IOException {
        super.writeTo(new CountingOutputStream(outStream, this.listener));
    }

    public interface ProgressListener {
        void onTransferred(long num);
    }

    public static class CountingOutputStream extends FilterOutputStream {

        private final ProgressListener listener;
        private long transferred;

        public CountingOutputStream(final OutputStream out, final ProgressListener listener) {
            super(out);
            this.listener = listener;
            this.transferred = 0;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            out.write(b, off, len);
            this.transferred += len;
            if (listener != null) {
                this.listener.onTransferred(this.transferred);
            }
        }

        public void write(int b) throws IOException {
            out.write(b);
            this.transferred++;
            if (listener != null) {
                this.listener.onTransferred(this.transferred);
            }
        }
    }
}
