package com.stringee.common;

import com.stringee.StringeeClient;
import com.stringee.common.event.EventManager;
import com.stringee.database.DBHandler;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.messaging.Message;
import com.stringee.messaging.Message.Type;
import com.stringee.messaging.StringeeChange;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class UploadFileService {
    private static volatile UploadFileService instance;
    private final HttpClient httpclient;
    private long totalSize = 0;
    private final ScheduledExecutorService executor;

    public UploadFileService() {
        executor = Executors.newSingleThreadScheduledExecutor();
        httpclient = new DefaultHttpClient();
    }

    public static UploadFileService getInstance() {
        if (instance == null) {
            synchronized (UploadFileService.class) {
                if (instance == null) {
                    instance = new UploadFileService();
                }
            }
        }
        return instance;
    }

    public void upload(StringeeClient client, int requestId, Message message) {
        executor.execute(() -> {
            Map<String, Object> result = uploadFile(client, requestId, message);
            int r = -1;
            String msg = "Failed to upload file";
            Object rObj = result.get("r");
            if (rObj != null) {
                r = (int) rObj;
            }
            Object msgObj = result.get("message");
            if (msgObj != null) {
                msg = (String) msgObj;
            }
            if (r == 0) {
                message.setFileUrl((String) result.get("file_url"));
                if (result.containsKey("thumbnail_url")) {
                    message.setThumbnailUrl((String) result.get("thumbnail_url"));
                }
                client.getDbExecutor().execute(() -> DBHandler.getInstance(client.getContext()).updateFileUrl(message));

                SendPacketUtils.sendMessage(client, requestId, message);
            } else {
                StatusListener statusListener = Common.statusListenerMap.get(requestId);
                if (statusListener != null) {
                    statusListener.onError(new StringeeError(r, msg));
                }

                client.getDbExecutor().execute(() -> DBHandler.getInstance(client.getContext()).deleteLocalMessages(message.getConversationId(), client.getUserId(), new String[]{message.getLocalId()}));
                EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.DELETE, message));
            }
        });
    }

    private Map<String, Object> uploadFile(StringeeClient client, int requestId, Message message) {
        HttpPost httppost = new HttpPost(APIUrlUtils.getInstance().getUploadFileUrl());
        String uploadFileResponse = null;
        String updateThumbnailResponse = null;
        StatusListener listener = Common.statusListenerMap.get(requestId);
        Map<String, Object> result = new HashMap<>();
        result.put("r", 100);
        result.put("message", "Failed to upload file");
        try {
            httppost.addHeader("X-STRINGEE-AUTH", client.getToken());
            MyMultiPartEntity entity = new MyMultiPartEntity(num -> {
                if (listener != null) {
                    int percent = (int) ((num / (float) totalSize) * 100);
                    listener.onProgress(percent);
                }
            });

            File sourceFile = new File(message.getFilePath());
            entity.addPart("file", new FileBody(sourceFile));
            httppost.setEntity(entity);
            totalSize = entity.getContentLength();

            HttpResponse response = httpclient.execute(httppost);
            HttpEntity httpEntity = response.getEntity();
            int statusCode = response.getStatusLine().getStatusCode();
            uploadFileResponse = EntityUtils.toString(httpEntity);
            if (statusCode != 200) {
                JSONObject responseObj = new JSONObject(uploadFileResponse);
                responseObj.put("message", "Error occurred! Http Status Code: " + statusCode);
                uploadFileResponse = responseObj.toString();
            }

            Type type = message.getType();
            if (type == Type.VIDEO || type == Type.PHOTO) {
                String thumbnail = message.getThumbnail();
                if (!Utils.isEmpty(thumbnail)) {
                    File thumbnailFile = new File(thumbnail);
                    MyMultiPartEntity thumbEntity = new MyMultiPartEntity(num -> {

                    });
                    thumbEntity.addPart("file", new FileBody(thumbnailFile));
                    httppost.setEntity(thumbEntity);
                    HttpResponse thumbResponse = httpclient.execute(httppost);
                    HttpEntity thumbHttpEntity = thumbResponse.getEntity();
                    int thumbStatusCode = thumbResponse.getStatusLine().getStatusCode();
                    updateThumbnailResponse = EntityUtils.toString(thumbHttpEntity);
                    if (thumbStatusCode != 200) {
                        JSONObject responseObj = new JSONObject(updateThumbnailResponse);
                        responseObj.put("message", "Error occurred! Http Status Code: " + statusCode);
                        updateThumbnailResponse = responseObj.toString();
                    }
                }
            }
        } catch (Exception e) {
            Utils.reportException(UploadFileService.class, e);
        }

        if (!Utils.isEmpty(uploadFileResponse)) {
            try {
                JSONObject jsonResult = new JSONObject(uploadFileResponse);
                int r = jsonResult.getInt("r");
                if (r == 0) {
                    result.put("file_url", jsonResult.getString("filename"));
                } else {
                    result.put("message", jsonResult.getString("message"));
                }
                result.put("r", r);
            } catch (JSONException e) {
                Utils.reportException(UploadFileService.class, e);
            }
        }

        if (!Utils.isEmpty(updateThumbnailResponse)) {
            try {
                JSONObject jsonResult = new JSONObject(updateThumbnailResponse);
                int r = jsonResult.getInt("r");
                if (r == 0) {
                    result.put("thumbnail_url", jsonResult.getString("filename"));
                }
            } catch (JSONException e) {
                Utils.reportException(UploadFileService.class, e);
            }
        }
        return result;
    }
}
