package com.stringee.exception;

import androidx.annotation.NonNull;

public class StringeeError {

    private int code;
    private String message;

    /**
     * Constructs a new StringeeError.
     */
    public StringeeError() {
    }

    /**
     * Constructs a new StringeeError.
     *
     * @param code the error code of this exception
     * @param message the detail message of this exception
     */
    public StringeeError(int code, String message) {
        this.code = code;
        this.message = message;
    }

    /**
     * Constructs a new StringeeError.
     *
     * @param message the detail message of this exception
     */
    public StringeeError(String message) {
        this.message = message;
    }

    @NonNull
    @Override
    public String toString() {
        return message;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
