package com.stringee.messaging;

public enum ChannelType {
    NORMAL(0),
    LIVECHAT(1),
    FACEBOOK(2),
    ZALO(3);

    private final short value;

    ChannelType(final int value) {
        this.value = (short) value;
    }

    public short getValue() {
        return value;
    }

    public static ChannelType getType(int value) {
        switch (value) {
            case 1:
                return LIVECHAT;
            case 2:
                return FACEBOOK;
            case 3:
                return ZALO;
            default:
                return NORMAL;
        }
    }
}
