package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.database.DBHandler;
import com.stringee.messaging.ChatStatus;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.User;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class ChatConversationEnd extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                String convId = packet.getFieldString("convId");
                String endedBy = packet.getFieldString("endedby");
                DBHandler dbHandler = DBHandler.getInstance(client.getContext());
                Conversation conversation = dbHandler.getConversationByRemoteId(convId, client.getUserId());
                if (conversation != null) {
                    if (!conversation.isEnded()) {
                        conversation.setEnded(true);
                        conversation.setChatStatus(ChatStatus.ENDED);
                        User user;
                        if (Utils.isEmpty(endedBy)) {
                            user = dbHandler.getUser(client.getUserId());
                        } else {
                            user = dbHandler.getUser(endedBy);
                        }
                        EventManager.sendChatSupportHandledEvent(client, conversation, user);
                        client.getDbExecutor().execute(() -> dbHandler.updateConversation(conversation));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(ChatConversationEnd.class, e);
            }
        });
    }
}
