package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StringeeRoomListener;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.video.LocalParticipant;
import com.stringee.video.RemoteParticipant;
import com.stringee.video.StringeeRoom;
import com.stringee.video.StringeeVideoTrack;
import com.stringee.video.StringeeVideoTrack.TrackType;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by luannguyen on 10/21/2016.
 */

public class ConnectRoom extends ProcessorBase {

    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                StringeeRoom room = client.getRoomRequest().get(requestId);
                if (room == null) {
                    return;
                }
                client.getRoomRequest().remove(requestId);
                StringeeRoomListener listener = room.getListener();
                if (r == 0) {
                    String roomId = packet.getFieldString("roomId");
                    if (Utils.isEmpty(roomId)) {
                        if (listener != null) {
                            listener.onError(room, new StringeeError(r, "Failed to connect the room"));
                        }
                        return;
                    }
                    boolean permissionControlRoom = packet.getBoolean("permissionControlRoom");
                    boolean permissionPublish = packet.getBoolean("permissionPublish");
                    boolean permissionSubscribe = packet.getBoolean("permissionSubscribe");
                    boolean record = packet.getBoolean("record");
                    JSONArray userArray = (JSONArray) packet.getField("users");
                    JSONArray trackArray = (JSONArray) packet.getField("tracks");

                    room.setId(roomId);
                    room.setState(StringeeRoom.State.CONNECTED);
                    room.setRecorded(record);

                    LocalParticipant localParticipant = new LocalParticipant(client.getUserId());
                    localParticipant.setCanControl(permissionControlRoom);
                    localParticipant.setCanPublish(permissionPublish);
                    localParticipant.setCanSubscribe(permissionSubscribe);
                    room.setLocalParticipant(localParticipant);

                    Map<String, List<StringeeVideoTrack>> videoTrackMap = new HashMap<>();
                    if (trackArray != null) {
                        for (int i = 0; i < trackArray.length(); i++) {
                            JSONObject jsonObject = trackArray.getJSONObject(i);
                            StringeeVideoTrack videoTrack = new StringeeVideoTrack();
                            videoTrack.setClient(client);
                            videoTrack.setId(jsonObject.getString("serverId"));
                            videoTrack.setAudio(jsonObject.getBoolean("audio"));
                            videoTrack.setVideo(jsonObject.getBoolean("video"));
                            videoTrack.setScreenCapture(jsonObject.getBoolean("screen"));
                            videoTrack.setPlayer(jsonObject.optBoolean("isPlayer", false));
                            videoTrack.setUserId(jsonObject.getString("userPublish"));
                            videoTrack.setRoomId(roomId);
                            if (videoTrack.isPlayer()) {
                                videoTrack.setTrackType(TrackType.PLAYER);
                            }
                            if (videoTrack.isScreenCapture()) {
                                videoTrack.setTrackType(TrackType.SCREEN);
                            }

                            // Add remote tracks
                            room.getVideoTrackMap().put(videoTrack.getId(), videoTrack);

                            List<StringeeVideoTrack> tracks = videoTrackMap.get(videoTrack.getUserId());
                            if (tracks == null) {
                                tracks = new ArrayList<>();
                                videoTrackMap.put(videoTrack.getUserId(), tracks);
                            }
                            tracks.add(videoTrack);
                        }
                    }

                    if (userArray != null) {
                        for (int i = 0; i < userArray.length(); i++) {
                            JSONObject jsonObject = userArray.getJSONObject(i);
                            String userId = jsonObject.getString("userId");
                            RemoteParticipant remoteParticipant = new RemoteParticipant(userId);
                            List<StringeeVideoTrack> videoTracks = videoTrackMap.get(userId);
                            if (!Utils.isEmpty(videoTracks)) {
                                for (int j = 0; j < videoTracks.size(); j++) {
                                    remoteParticipant.addVideoTrack(videoTracks.get(j));
                                }
                            }
                            room.getParticipantMap().put(userId, remoteParticipant);
                        }
                    }

                    client.getRoomMap().put(roomId, room);
                    if (listener != null) {
                        listener.onConnected(room);
                    }
                } else {
                    if (listener != null) {
                        listener.onError(room, new StringeeError(r, "Failed to connect the room"));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(ConnectRoom.class, e);
            }
        });
    }
}
