package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.database.DBHandler;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.Message;
import com.stringee.messaging.StringeeChange;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class EditMessage extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                StatusListener statusListener = Common.statusListenerMap.get(requestId);
                if (r == 0) {
                    if (statusListener != null) {
                        statusListener.onSuccess();
                    }
                    Message message = client.getMessagesMap().get(requestId);
                    if (message != null) {
                        message.setUpdateAt(System.currentTimeMillis());
                        client.getDbExecutor().execute(() -> DBHandler.getInstance(client.getContext()).updateMessageByMsgId(message));
                        EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.UPDATE, message));
                        client.getConversationFromServer(message.getConversationId(), new CallbackListener<Conversation>() {
                            @Override
                            public void onSuccess(Conversation conversation) {
                                if (message.getId().equals(conversation.getLastMessage().getId())) {
                                    EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.UPDATE, conversation));
                                }
                            }
                        });
                    }
                    client.getMessagesMap().remove(requestId);
                } else {
                    if (statusListener != null) {
                        statusListener.onError(new StringeeError(r, packet.getFieldString("message")));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(EditMessage.class, e);
            }
        });
    }
}
