package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.database.DBHandler;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.Message;
import com.stringee.messaging.StringeeChange;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONArray;
import org.json.JSONException;

public class RevokeMessages extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                StatusListener statusListener = Common.statusListenerMap.get(requestId);
                DBHandler dbHandler = DBHandler.getInstance(client.getContext());
                if (r == 0) {
                    if (statusListener != null) {
                        statusListener.onSuccess();
                    }
                    String convId = packet.getFieldString("convId");
                    JSONArray msgIds = (JSONArray) packet.getField("msgIds");
                    if (!Utils.isEmpty(msgIds)) {
                        String[] ids = new String[msgIds.length()];
                        for (int i = 0; i < msgIds.length(); i++) {
                            String msgId = msgIds.getString(i);
                            ids[i] = msgId;
                            Message message = dbHandler.getMessageByMsgId(convId, msgId, client.getUserId(), false);
                            if (message != null) {
                                EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.DELETE, message));
                            }
                        }
                        client.getDbExecutor().execute(() -> dbHandler.deleteMessages(convId, client.getUserId(), ids));
                        client.getConversationFromServer(convId, new CallbackListener<Conversation>() {
                            @Override
                            public void onSuccess(Conversation conversation) {
                                EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.UPDATE, conversation));
                            }
                        });
                    }
                } else {
                    if (statusListener != null) {
                        statusListener.onError(new StringeeError(r, packet.getFieldString("message")));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(RevokeMessages.class, e);
            }
        });
    }
}
