package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class UpdateConversation extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                StatusListener statusListener = Common.statusListenerMap.get(requestId);
                if (r == 0) {
                    if (statusListener != null) {
                        statusListener.onSuccess();
                    }
                } else {
                    if (statusListener != null) {
                        statusListener.onError(new StringeeError(r, "Failed to update the conversation."));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(UpdateConversation.class, e);
            }
        });
    }
}
