package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Utils;
import com.stringee.listener.StringeeRoomListener;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.video.RemoteParticipant;
import com.stringee.video.StringeeRoom;
import com.stringee.video.StringeeVideoTrack;
import com.stringee.video.StringeeVideoTrack.TrackType;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

public class VideoTrackAdded extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                String roomId = packet.optFieldString("roomId");
                JSONObject jsonObject = packet.optFieldJSONObject("track");
                String trackId = jsonObject.getString("serverId");
                StringeeRoom room = client.getRoomMap().get(roomId);
                if (room == null) {
                    return;
                }
                boolean isLocal = false;
                List<StringeeVideoTrack> videoTracks = room.getVideoTracks();
                if (!Utils.isEmpty(videoTracks)) {
                    for (int i = 0; i < videoTracks.size(); i++) {
                        StringeeVideoTrack videoTrack = videoTracks.get(i);
                        if (videoTrack.getId() != null && videoTrack.getId().equals(trackId) &&
                                videoTrack.isLocal()) {
                            isLocal = true;
                            break;
                        }
                    }
                }

                if (!isLocal) {
                    StringeeVideoTrack videoTrack = new StringeeVideoTrack();
                    videoTrack.setClient(client);
                    videoTrack.setId(trackId);
                    videoTrack.setAudio(jsonObject.getBoolean("audio"));
                    videoTrack.setVideo(jsonObject.getBoolean("video"));
                    videoTrack.setScreenCapture(jsonObject.getBoolean("screen"));
                    videoTrack.setPlayer(jsonObject.optBoolean("isPlayer", false));
                    videoTrack.setUserId(jsonObject.getString("userPublish"));
                    videoTrack.setRoomId(roomId);
                    if (videoTrack.isPlayer()) {
                        videoTrack.setTrackType(TrackType.PLAYER);
                    }
                    if (videoTrack.isScreenCapture()) {
                        videoTrack.setTrackType(TrackType.SCREEN);
                    }

                    room.getVideoTrackMap().put(trackId, videoTrack);

                    RemoteParticipant remoteParticipant =
                            room.getRemoteParticipant(videoTrack.getUserId());
                    if (remoteParticipant != null) {
                        remoteParticipant.addVideoTrack(videoTrack);
                    }
                    StringeeRoomListener listener = room.getListener();
                    if (listener != null) {
                        listener.onVideoTrackAdded(room, videoTrack);
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(VideoTrackAdded.class, e);
            }
        });
    }
}
