package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Constant;
import com.stringee.common.SendPacketUtils;
import com.stringee.common.Utils;
import com.stringee.database.DBHandler;
import com.stringee.exception.StringeeError;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.Message;
import com.stringee.messaging.Message.MsgType;
import com.stringee.messaging.Message.Type;
import com.stringee.messaging.User;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class XChatLoadMessage extends ProcessorBase {
    @Override
    public void process(final StringeeClient client, final Packet packet) {
        client.getExecutor().execute(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                CallbackListener<List<Message>> listener = Common.callbackListenerMap.get(requestId);
                if (r == 0) {
                    JSONArray jsonArray = (JSONArray) packet.getField("msgs");
                    List<Message> messages = new ArrayList<>();
                    if (!Utils.isEmpty(jsonArray)) {
                        DBHandler dbHandler = DBHandler.getInstance(client.getContext());
                        String convId = packet.getFieldString("convId");
                        Conversation conversation = dbHandler.getConversationByRemoteId(convId, client.getUserId());
                        long lastMsgReceivedSeq = 0;
                        long lastMsgSeenSeq = 0;
                        long myLastMsgReceivedSeq = 0;
                        long myLastMsgSeenSeq = 0;
                        if (conversation != null) {
                            // Get last msg received, seen here
                            lastMsgReceivedSeq = dbHandler.getLastMsgReceivedSeq(convId, client.getUserId());
                            lastMsgSeenSeq = dbHandler.getLastMsgSeenSeq(convId, client.getUserId());
                            myLastMsgReceivedSeq = dbHandler.getMyLastMsgReceivedSeq(convId, client.getUserId());
                            myLastMsgSeenSeq = dbHandler.getMyLastMsgSeenSeq(convId, client.getUserId());
                        }

                        for (int i = 0; i < jsonArray.length(); i++) {
                            JSONObject jsonObject = jsonArray.getJSONObject(i);

                            String localId = jsonObject.optString("localDbId");
                            String msgId = jsonObject.optString("id");
                            long createdTime = jsonObject.optLong("created");
                            String from = jsonObject.optString("user");
                            long seq = jsonObject.optLong("seq");
                            String text;
                            double latitude = 0;
                            double longitude = 0;
                            String fileUrl = "";
                            String fileName = "";
                            long fileLength = 0;
                            String fileId = "";
                            String thumbnailUrl = "";
                            int duration = 0;
                            float ratio = 0;
                            String stickerName = "";
                            String stickerCategory = "";
                            String contact = "";
                            boolean isDeleted;
                            JSONObject messageObject = jsonObject.optJSONObject("content");
                            if (messageObject != null) {
                                text = messageObject.optString("content");
                                if (Utils.isEmpty(text)) {
                                    text = messageObject.optString("text");
                                }
                                Type type = Type.getType(jsonObject.optInt("type"));
                                switch (type) {
                                    case RENAME_CONVERSATION:
                                    case CREATE_CONVERSATION:
                                    case RATING:
                                    case NOTIFICATION:
                                        text = messageObject.toString();
                                        break;
                                    case LOCATION:
                                        JSONObject locationObject = messageObject.optJSONObject("location");
                                        if (locationObject != null) {
                                            latitude = locationObject.optDouble("lat");
                                            longitude = locationObject.optDouble("lon");
                                        }
                                        break;
                                    case CONTACT:
                                        JSONObject contactObject = messageObject.optJSONObject("contact");
                                        if (contactObject != null) {
                                            contact = contactObject.optString("vcard");
                                        }
                                        break;
                                    case PHOTO:
                                        JSONObject photoObject = messageObject.optJSONObject("photo");
                                        if (photoObject != null) {
                                            ratio = (float) photoObject.optDouble("ratio", 0);
                                            fileUrl = photoObject.optString("filePath");
                                            thumbnailUrl = photoObject.optString("thumbnail");
                                            fileId = photoObject.optString("file_id");
                                        }
                                        break;
                                    case VIDEO:
                                        JSONObject videoObject = messageObject.optJSONObject("video");
                                        if (videoObject != null) {
                                            ratio = (float) videoObject.optDouble("ratio", 0);
                                            fileUrl = videoObject.optString("filePath");
                                            duration = videoObject.optInt("duration");
                                            thumbnailUrl = videoObject.optString("thumbnail");
                                            fileId = videoObject.optString("file_id");
                                            fileName = videoObject.optString("filename");
                                        }
                                        break;
                                    case AUDIO:
                                        JSONObject audioObject = messageObject.optJSONObject("audio");
                                        if (audioObject != null) {
                                            fileUrl = audioObject.optString("filePath");
                                            duration = audioObject.optInt("duration");
                                            fileId = audioObject.optString("file_id");
                                            fileName = audioObject.optString("filename");
                                        }
                                        break;
                                    case FILE:
                                        JSONObject fileObject = messageObject.optJSONObject("file");
                                        if (fileObject != null) {
                                            fileUrl = fileObject.optString("filePath");
                                            fileName = fileObject.optString("filename");
                                            fileLength = fileObject.optLong("length");
                                            fileId = fileObject.optString("file_id");
                                        }
                                        break;
                                    case STICKER:
                                        JSONObject stickerObject = messageObject.optJSONObject("sticker");
                                        if (stickerObject != null) {
                                            stickerCategory = stickerObject.optString("category");
                                            stickerName = stickerObject.optString("name");
                                        }
                                        break;
                                }

                                int deletedStatus = packet.optFieldInt("deletedStatus");
                                isDeleted = deletedStatus != 0;

                                Message message = dbHandler.getMessageByMsgId(convId, msgId, client.getUserId(), false);
                                if (message == null) {
                                    message = new Message();
                                }
                                message.setConversationId(convId);
                                message.setConvLocalId(localId);
                                message.setId(msgId);
                                message.setCreatedAt(createdTime);
                                User sender = new User(from);
                                JSONObject senderInfoObject = jsonObject.optJSONObject("senderInfo");
                                if (senderInfoObject != null) {
                                    if (senderInfoObject.has("display_name")) {
                                        String displayName = senderInfoObject.getString("display_name");
                                        sender.setName(displayName);
                                    }
                                    if (senderInfoObject.has("avatar_url")) {
                                        String avatarUrl = senderInfoObject.optString("avatar_url");
                                        sender.setName(avatarUrl);
                                    }
                                }
                                message.setSender(sender);
                                message.setSequence(seq);
                                message.setText(text);
                                message.setType(type);
                                message.setLatitude(latitude);
                                message.setLongitude(longitude);
                                message.setFileUrl(fileUrl);
                                message.setThumbnailUrl(thumbnailUrl);
                                message.setDuration(duration);
                                message.setImageRatio(ratio);
                                message.setContact(contact);
                                message.setFileName(fileName);
                                message.setFileLength(fileLength);
                                message.setFileId(fileId);
                                message.setClientId(client.getUserId());
                                message.setStickerCategory(stickerCategory);
                                message.setStickerName(stickerName);
                                if (from.equals(client.getUserId())) {
                                    message.setMsgType(MsgType.SEND);
                                    message.setState(Message.State.SENT);
                                    if (seq <= lastMsgReceivedSeq) {
                                        message.setState(Message.State.DELIVERED);
                                    }
                                    if (seq <= lastMsgSeenSeq) {
                                        message.setState(Message.State.READ);
                                    }
                                } else {
                                    message.setMsgType(MsgType.RECEIVE);
                                    message.setState(Message.State.DELIVERED);
                                    if (seq <= myLastMsgSeenSeq) {
                                        message.setState(Message.State.READ);
                                    }
                                }

                                JSONObject customObject = messageObject.optJSONObject("metadata");
                                if (customObject != null) {
                                    message.setCustomData(customObject);
                                }
                                message.setDeleted(isDeleted);
                                messages.add(message);
                            }
                        }

                        Collections.sort(messages, (message, t1) -> {
                            long createdTime = message.getCreatedAt();
                            if (createdTime == 0) {
                                createdTime = message.getCreatedOnLocalAt();
                            }
                            long createdTime1 = t1.getCreatedAt();
                            if (createdTime1 == 0) {
                                createdTime1 = t1.getCreatedOnLocalAt();
                            }
                            if (createdTime > createdTime1) {
                                return 1;
                            } else {
                                return -1;
                            }
                        });

                        if (!messages.isEmpty()) {
                            Message lastMsg = null;
                            for (int i = messages.size() - 1; i >= 0; i--) {
                                if (messages.get(i).getMsgType() == MsgType.RECEIVE) {
                                    lastMsg = messages.get(i);
                                    break;
                                }
                            }
                            if (lastMsg != null && lastMsg.getSequence() > myLastMsgReceivedSeq) {
                                SendPacketUtils.sendMessageReport(client, requestId, lastMsg, Constant.MESSAGE_STATE_DELIVERED);
                            }
                        }

                        client.getDbExecutor().execute(() -> {
                            if (!Utils.isEmpty(messages)) {
                                for (int i = 0; i < messages.size(); i++) {
                                    Message message = messages.get(i);
                                    dbHandler.syncMessage(message);
                                }
                            }
                        });
                    }
                    if (listener != null) {
                        listener.onSuccess(messages);
                    }
                } else {
                    if (listener != null) {
                        listener.onError(new StringeeError(r, "Failed to load messages"));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(XChatLoadMessage.class, e);
            }
        });
    }
}
