package com.stringee.network.tcpclient;

import com.stringee.StringeeClient;
import com.stringee.common.Utils;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.network.tcpclient.packet.ServiceType;

import java.util.concurrent.LinkedBlockingQueue;

/**
 * @author Alex
 */

public class PacketSenderThread extends Thread {

    public PacketSenderThread(StringeeClient client) {
        this.client = client;
    }

    private final LinkedBlockingQueue<Packet> packetQueue = new LinkedBlockingQueue<>();
    private final LinkedBlockingQueue<Packet> queueNotLogin = new LinkedBlockingQueue<>();
    private boolean running = false;
    private TcpClient tcpClient;
    private final StringeeClient client;

    public void send(Packet packet) {
        try {
            packetQueue.put(packet);
        } catch (InterruptedException ex) {
            Utils.reportException(PacketSenderThread.class, ex);
        }
    }

    public void sendAllPacketInQueue() {
        while (!queueNotLogin.isEmpty()) {
            try {
                Packet packet = queueNotLogin.take();
                packetQueue.put(packet);
            } catch (InterruptedException ex) {
                Utils.reportException(PacketSenderThread.class, ex);
            }
        }
    }

    @Override
    public void run() {
        if (running) {
            return;
        }
        running = true;
        while (running) {
            try {
                Packet packet = packetQueue.take();
                if (tcpClient != null && client.isConnected()) {
                    tcpClient.send(packet);
                } else {
                    if (packet.getService() == ServiceType.AUTHEN.getValue()) {
                        if (tcpClient != null && tcpClient.isConnected()) {
                            tcpClient.send(packet);
                        } else {
                            queueNotLogin.put(packet);
                        }
                    } else {
                        queueNotLogin.put(packet);
                    }
                }
            } catch (InterruptedException ex) {
                Utils.reportException(PacketSenderThread.class, ex);
            }
        }
    }

    public LinkedBlockingQueue<Packet> getPacketQueue() {
        return packetQueue;
    }

    public LinkedBlockingQueue<Packet> getQueueNotLogin() {
        return queueNotLogin;
    }

    public boolean isRunning() {
        return running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void setTcpClient(TcpClient tcpClient) {
        this.tcpClient = tcpClient;
    }
}
