package com.stringee.video;

import android.util.Log;

import com.stringee.call.StringeeIceCandidate;
import com.stringee.common.Common;
import com.stringee.common.SendPacketUtils;

import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.RtpReceiver;

public class VideoObserver implements PeerConnection.Observer {
    private final StringeeVideoTrack videoTrack;

    public VideoObserver(StringeeVideoTrack videoTrack) {
        this.videoTrack = videoTrack;
    }

    @Override
    public void onSignalingChange(PeerConnection.SignalingState signalingState) {
        Log.d("Stringee", "onSignalingChange: " + signalingState.toString());
    }

    @Override
    public void onIceConnectionChange(PeerConnection.IceConnectionState iceConnectionState) {
        Log.d("Stringee", "onIceConnectionChange: " + iceConnectionState.toString());
        // Send media state to server for logging
        SendPacketUtils.sendMediaState(videoTrack, iceConnectionState);
        StringeeVideoTrack.Listener listener = videoTrack.getListener();
        if (listener != null) {
            if (iceConnectionState == PeerConnection.IceConnectionState.CONNECTED) {
                listener.onMediaStateChange(StringeeVideoTrack.MediaState.CONNECTED);
            } else if (iceConnectionState == PeerConnection.IceConnectionState.DISCONNECTED) {
                listener.onMediaStateChange(StringeeVideoTrack.MediaState.DISCONNECTED);
            }
        }
//        if (iceConnectionState == IceConnectionState.FAILED){
//            videoTrack.restartICE();
//        }
    }

    @Override
    public void onIceConnectionReceivingChange(boolean b) {

    }

    @Override
    public void onIceGatheringChange(PeerConnection.IceGatheringState iceGatheringState) {
        Log.d("Stringee", "onIceGatheringChange: " + iceGatheringState.toString());
    }

    @Override
    public void onIceCandidate(IceCandidate iceCandidate) {
        StringeeIceCandidate ice = new StringeeIceCandidate(iceCandidate.sdpMid, iceCandidate.sdpMLineIndex, iceCandidate.sdp);
        int requestId;
        synchronized (Common.lock) {
            requestId = ++Common.requestId;
        }
        SendPacketUtils.sendVideoCandidate(videoTrack.getClient(), requestId, videoTrack, ice);
    }

    @Override
    public void onIceCandidatesRemoved(IceCandidate[] iceCandidates) {

    }

    @Override
    public void onAddStream(MediaStream mediaStream) {
        Log.d("Stringee", "onAddStream");
        videoTrack.setMediaStream(mediaStream);
        StringeeVideoTrack.Listener listener = videoTrack.getListener();
        if (listener != null) {
            listener.onMediaAvailable();
        }
    }

    @Override
    public void onRemoveStream(MediaStream mediaStream) {
        Log.d("Stringee", "onRemoveStream");
    }

    @Override
    public void onDataChannel(DataChannel dataChannel) {

    }

    @Override
    public void onRenegotiationNeeded() {

    }

    @Override
    public void onAddTrack(RtpReceiver rtpReceiver, MediaStream[] mediaStreams) {

    }
}
