package com.stringee.database;

public class MessageConstant {
    public static final String TABLE_NAME = "messages";
    public static final String ID = "id";
    public static final String MESSAGE_ID = "message_id";
    public static final String LOCAL_ID = "local_id";
    public static final String CONV_LOCAL_ID = "conv_local_id";
    public static final String CONVERSATION_ID = "conversation_id";
    public static final String AUTHOR = "author";
    public static final String CREATED_AT = "create_at";
    public static final String SERVER_CREATED_AT = "server_created_at";
    public static final String UPDATE_AT = "update_at";
    public static final String STATE = "state";
    public static final String TYPE = "type";
    public static final String FILE_PATH = "file_path";
    public static final String THUMBNAIL = "thumbnail";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String ADDRESS = "address";
    public static final String SEQUENCE = "sequence";
    public static final String MESSAGE_TYPE = "message_type";
    public static final String TEXT = "text";
    public static final String FILE_URL = "file_url";
    public static final String THUMBNAIL_URL = "thumbnail_url";
    public static final String DURATION = "duration";
    public static final String RATIO = "ratio";
    public static final String CONTACT = "contact";
    public static final String FILE_NAME = "file_name";
    public static final String FILE_LENGTH = "file_length";
    public static final String FILE_ID = "file_id";
    public static final String USER_ID = "user_id";
    public static final String STICKER_CATEGORY = "sticker_category";
    public static final String STICKER_NAME = "sticker_name";
    public static final String CUSTOM_DATA = "custom_data";
    public static final String DELETED = "deleted";
    public static final String AUTHOR_NAME = "author_name";
    public static final String AUTHOR_AVATAR = "author_avatar";

    public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS " +
            TABLE_NAME + " (" +
            ID + " INTEGER PRIMARY KEY," +
            MESSAGE_ID + " TEXT," +
            LOCAL_ID + " TEXT," +
            CONV_LOCAL_ID + " TEXT," +
            CONVERSATION_ID + " TEXT," +
            AUTHOR + " TEXT," +
            CREATED_AT + " INTEGER," +
            SERVER_CREATED_AT + " INTEGER," +
            UPDATE_AT + " INTEGER," +
            STATE + " INTEGER," +
            TYPE + " INTEGER," +
            FILE_PATH + " TEXT," +
            THUMBNAIL + " TEXT," +
            LATITUDE + " REAL," +
            LONGITUDE + " REAL," +
            ADDRESS + " TEXT," +
            SEQUENCE + " INTEGER," +
            MESSAGE_TYPE + " INTEGER," +
            TEXT + " TEXT," +
            FILE_URL + " TEXT," +
            THUMBNAIL_URL + " TEXT," +
            DURATION + " INTEGER," +
            RATIO + " REAL," +
            CONTACT + " TEXT," +
            FILE_NAME + " TEXT," +
            FILE_LENGTH + " INTEGER," +
            USER_ID + " TEXT," +
            STICKER_CATEGORY + " TEXT," +
            STICKER_NAME + " TEXT," +
            CUSTOM_DATA + " TEXT," +
            DELETED + " INTEGER DEFAULT 0, " +
            AUTHOR_NAME + " TEXT," +
            AUTHOR_AVATAR + " TEXT," +
            FILE_ID + " TEXT," +
            "UNIQUE(" + MESSAGE_ID + "," + USER_ID + "))";

    public static final String CREATE_SENDER_ID_INDEX = "CREATE INDEX author_index ON " + TABLE_NAME + "(" + AUTHOR
            + ")";
}
