package com.stringee.listener;

import com.stringee.exception.StringeeError;
import com.stringee.video.RemoteParticipant;
import com.stringee.video.StringeeRoom;
import com.stringee.video.StringeeVideoTrack;
import com.stringee.video.StringeeVideoTrack.MediaType;

import org.json.JSONObject;

/**
 * Created by luannguyen on 10/19/2017.
 */

public interface StringeeRoomListener {
    void onConnected(StringeeRoom stringeeRoom);

    void onDisconnected(StringeeRoom stringeeRoom);

    void onError(StringeeRoom stringeeRoom, StringeeError error);

    void onParticipantConnected(StringeeRoom stringeeRoom, RemoteParticipant remoteParticipant);

    void onParticipantDisconnected(StringeeRoom stringeeRoom, RemoteParticipant remoteParticipant);

    void onVideoTrackAdded(StringeeRoom stringeeRoom, StringeeVideoTrack videoTrack);

    void onVideoTrackRemoved(StringeeRoom stringeeRoom, StringeeVideoTrack videoTrack);

    void onMessage(StringeeRoom stringeeRoom, JSONObject msg, RemoteParticipant remoteParticipant);

    void onVideoTrackNotification(RemoteParticipant participant, StringeeVideoTrack videoTrack, MediaType mediaType);
}
