package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.exception.StringeeError;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.StringeeChange;
import com.stringee.messaging.User;
import com.stringee.messaging.User.Role;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class AddParticipants extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                CallbackListener listener = Common.callbackListenerMap.get(requestId);
                if (r == 0) {
                    JSONArray parsArray = packet.optFieldJSONArray("added");
                    List<User> users = new ArrayList<>();
                    String convId = packet.getFieldString("convId");
                    if (!Utils.isEmpty(parsArray)) {
                        for (int i = 0; i < parsArray.length(); i++) {
                            JSONObject jsonObject = parsArray.getJSONObject(i);
                            String userId = jsonObject.getString("user");
                            String name = jsonObject.optString("displayName");
                            String avatar = jsonObject.optString("avatarUrl");
                            String role = jsonObject.optString("role");

                            User user = new User(userId);
                            user.setName(name);
                            user.setAvatarUrl(avatar);
                            user.setRole(Role.getRole(role));
                            users.add(user);
                        }
                    }
                    if (listener != null) {
                        listener.onSuccess(users);
                    }
                    client.getConversationFromServer(convId, new CallbackListener<Conversation>() {
                        @Override
                        public void onSuccess(Conversation conversation) {
                            EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.UPDATE, conversation));
                        }
                    });
                } else {
                    String message = packet.getFieldString("message");
                    if (listener != null) {
                        listener.onError(new StringeeError(r, message));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(AddParticipants.class, e);
            }
        });
    }
}
